"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsSampleDataAvailable = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _indices = require("../utils/indices");
var _use_user_permissions = require("./api/use_user_permissions");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasRequiredLicense = (minimumLicenseType, license) => license.isAvailable && license.isActive && license.hasAtLeast(minimumLicenseType);
const useIsSampleDataAvailable = () => {
  const {
    licensing,
    sampleDataIngest
  } = (0, _use_kibana.useKibana)().services;
  const indexName = (0, _react.useMemo)(() => (0, _indices.generateRandomIndexName)(), []);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(indexName);
  const license = (0, _useObservable.default)(licensing.license$, null);
  const hasLicense = (0, _react.useMemo)(() => sampleDataIngest !== null && sampleDataIngest !== void 0 && sampleDataIngest.minimumLicenseType && license ? hasRequiredLicense(sampleDataIngest === null || sampleDataIngest === void 0 ? void 0 : sampleDataIngest.minimumLicenseType, license) : true, [sampleDataIngest, license]);
  const isPluginAvailable = !!sampleDataIngest;
  const hasPrivileges = (0, _react.useMemo)(() => {
    var _userPrivileges$privi;
    return (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi = userPrivileges.privileges) === null || _userPrivileges$privi === void 0 ? void 0 : _userPrivileges$privi.canManageIndex) === true;
  }, [userPrivileges]);
  return {
    isUsageAvailable: isPluginAvailable && hasPrivileges && hasLicense,
    isPluginAvailable,
    hasPrivileges,
    hasRequiredLicense: hasLicense
  };
};
exports.useIsSampleDataAvailable = useIsSampleDataAvailable;