"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewsStats = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViewsStats = () => {
  const {
    dataViews
  } = (0, _use_kibana.useKibana)().services;
  const queryResult = (0, _reactQuery.useQuery)({
    queryKey: ['fetchDataViewsStats'],
    queryFn: async () => {
      if (!dataViews) {
        throw new Error('Data Views plugin is not available');
      }
      const dataViewsList = await dataViews.getIdsWithTitle();
      return dataViewsList;
    },
    select: dataViewsList => {
      const managedDataViews = dataViewsList.filter(dv => dv.managed).length;
      const userDataViews = dataViewsList.filter(dv => !dv.managed).length;
      const totalDataViews = dataViewsList.length;
      return {
        totalDataViews,
        managedDataViews,
        userDataViews
      };
    },
    enabled: !!dataViews
  });
  return {
    ...queryResult
  };
};
exports.useDataViewsStats = useDataViewsStats;