"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStartedFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_callouts = require("./doc_callouts");
var _doc_links = require("../../common/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_getting_started/public/components/footer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GettingStartedFooter = () => {
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const footerLinks = [{
    id: 'searchLabs',
    title: _i18n.i18n.translate('xpack.gettingStarted.searchLabs.title', {
      defaultMessage: 'Search Labs'
    }),
    description: _i18n.i18n.translate('xpack.gettingStarted.searchLabs.description', {
      defaultMessage: 'Explore the latest articles and tutorials on using Elasticsearch for AI/ML-powered search experiences.'
    }),
    buttonLabel: _i18n.i18n.translate('xpack.gettingStarted.searchLabs.buttonText', {
      defaultMessage: 'Visit Elasticsearch Labs'
    }),
    buttonHref: _doc_links.docLinks.visitSearchLabs,
    dataTestSubj: 'gettingStartedSearchLabs'
  }, {
    id: 'elasticTraining',
    title: _i18n.i18n.translate('xpack.gettingStarted.elasticTraining.title', {
      defaultMessage: 'Elastic training'
    }),
    description: _i18n.i18n.translate('xpack.gettingStarted.elasticTraining.description', {
      defaultMessage: 'Access expert-led trainings, interactive labs, comprehensive certification programs, and flexible self-paced learning courses.'
    }),
    buttonLabel: _i18n.i18n.translate('xpack.gettingStarted.elasticTraining.buttonText', {
      defaultMessage: 'Learn Elasticsearch'
    }),
    buttonHref: _doc_links.docLinks.elasticTraining,
    dataTestSubj: 'gettingStartedElasticTraining'
  }, {
    id: 'elasticsearchDocs',
    title: _i18n.i18n.translate('xpack.gettingStarted.elasticsearchDocs.title', {
      defaultMessage: 'Elasticsearch documentation'
    }),
    description: _i18n.i18n.translate('xpack.gettingStarted.elasticsearchDocumentation.description', {
      defaultMessage: 'Comprehensive reference material to help you learn, build, and deploy search solutions with Elasticsearch.'
    }),
    buttonLabel: _i18n.i18n.translate('xpack.gettingStarted.elasticsearchDocumentation.buttonText', {
      defaultMessage: 'View documentation'
    }),
    buttonHref: _doc_links.docLinks.elasticsearchDocs,
    dataTestSubj: 'gettingStartedViewDocumentation'
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: currentBreakpoint === 'xl' ? 'row' : 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, footerLinks.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.dataTestSubj,
    "data-test-subj": item.dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_doc_callouts.DocCallouts, {
    title: item.title,
    description: item.description,
    buttonHref: item.buttonHref,
    buttonLabel: item.buttonLabel,
    dataTestSubj: `${item.dataTestSubj}-btn`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
};
exports.GettingStartedFooter = GettingStartedFooter;