"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssignmentAction = void 0;
Object.defineProperty(exports, "getKey", {
  enumerable: true,
  get: function () {
    return _assignments.getKey;
  }
});
exports.sortByStatusAndTitle = exports.getOverriddenStatus = void 0;
var _lodash = require("lodash");
var _assignments = require("../../../common/assignments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return the assignment status resulting from applying
 * given `override` to given `initialStatus`.
 */
const getOverriddenStatus = (initialStatus, override) => {
  if (override) {
    return override === 'selected' ? 'full' : 'none';
  }
  return initialStatus;
};

/**
 * Return the assignment action that was effectively performed,
 * given an object's `initialStatus` and `override`
 */
exports.getOverriddenStatus = getOverriddenStatus;
const getAssignmentAction = (initialStatus, override) => {
  const overriddenStatus = getOverriddenStatus(initialStatus, override);
  if (initialStatus !== overriddenStatus) {
    if (overriddenStatus === 'full') {
      return 'added';
    }
    if (overriddenStatus === 'none') {
      return 'removed';
    }
  }
  return 'unchanged';
};
exports.getAssignmentAction = getAssignmentAction;
const statusPriority = {
  full: 1,
  partial: 2,
  none: 3
};

/**
 * Return a new array sorted by assignment status (full->partial->none) and then
 * by object title (desc).
 */
const sortByStatusAndTitle = (objects, statusMap) => {
  return (0, _lodash.sortBy)(objects, [obj => `${statusPriority[statusMap[(0, _assignments.getKey)(obj)]]}-${obj.title}`]);
};
exports.sortByStatusAndTitle = sortByStatusAndTitle;