"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformUpdateByQueryResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformUpdateByQueryErrorsResponse = res => {
  var _res$failures$map, _res$failures;
  const errors = (_res$failures$map = (_res$failures = res.failures) === null || _res$failures === void 0 ? void 0 : _res$failures.map(failure => {
    var _failure$cause$reason;
    return {
      id: failure.id,
      index: failure.index,
      code: failure.cause.type,
      message: (_failure$cause$reason = failure.cause.reason) !== null && _failure$cause$reason !== void 0 ? _failure$cause$reason : 'unknown error'
    };
  })) !== null && _res$failures$map !== void 0 ? _res$failures$map : [];
  return errors;
};
const transformUpdateByQueryResponse = res => {
  var _res$total, _res$updated;
  const failures = transformUpdateByQueryErrorsResponse(res);
  return {
    total: (_res$total = res.total) !== null && _res$total !== void 0 ? _res$total : 0,
    updated: (_res$updated = res.updated) !== null && _res$updated !== void 0 ? _res$updated : 0,
    ...(failures.length > 0 ? {
      failures
    } : {})
  };
};
exports.transformUpdateByQueryResponse = transformUpdateByQueryResponse;