"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fields = exports.VERSION = exports.TIMESTAMP = exports.SPACE_IDS = exports.KIBANA_NAMESPACE = exports.ALERT_WORKFLOW_TAGS = exports.ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_ASSIGNEE_IDS = exports.ALERT_UUID = exports.ALERT_URL = exports.ALERT_UPDATED_BY_USER_NAME = exports.ALERT_UPDATED_BY_USER_ID = exports.ALERT_UPDATED_AT = exports.ALERT_TIME_RANGE = exports.ALERT_STATUS = exports.ALERT_STATE_NAMESPACE = exports.ALERT_START = exports.ALERT_SEVERITY_IMPROVING = exports.ALERT_SCHEDULED_ACTION_THROTTLING = exports.ALERT_SCHEDULED_ACTION_GROUP = exports.ALERT_SCHEDULED_ACTION_DATE = exports.ALERT_RULE_UUID = exports.ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TAGS = exports.ALERT_RULE_REVISION = exports.ALERT_RULE_PRODUCER = exports.ALERT_RULE_PARAMETERS = exports.ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAME = exports.ALERT_RULE_EXECUTION_UUID = exports.ALERT_RULE_EXECUTION_TYPE = exports.ALERT_RULE_EXECUTION_TIMESTAMP = exports.ALERT_RULE_CONSUMER = exports.ALERT_RULE_CATEGORY = exports.ALERT_REASON = exports.ALERT_PREVIOUS_ACTION_GROUP = exports.ALERT_PENDING_RECOVERED_COUNT = exports.ALERT_NAMESPACE = exports.ALERT_MAINTENANCE_WINDOW_IDS = exports.ALERT_LAST_DETECTED = exports.ALERT_INTENDED_TIMESTAMP = exports.ALERT_INSTANCE_ID = exports.ALERT_INDEX_PATTERN = exports.ALERT_FLAPPING_HISTORY = exports.ALERT_FLAPPING = exports.ALERT_END = exports.ALERT_DURATION = exports.ALERT_CONSECUTIVE_MATCHES = exports.ALERT_CASE_IDS = exports.ALERT_ACTION_GROUP = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TIMESTAMP = exports.TIMESTAMP = '@timestamp';

// namespaces
const KIBANA_NAMESPACE = exports.KIBANA_NAMESPACE = 'kibana';
const ALERT_NAMESPACE = exports.ALERT_NAMESPACE = `${KIBANA_NAMESPACE}.alert`;
const ALERT_RULE_NAMESPACE = exports.ALERT_RULE_NAMESPACE = `${ALERT_NAMESPACE}.rule`;
const ALERT_SCHEDULED_ACTION_NAMESPACE = `${ALERT_NAMESPACE}.scheduled_action`;
const ALERT_STATE_NAMESPACE = exports.ALERT_STATE_NAMESPACE = `${ALERT_NAMESPACE}.state`;

// kibana.space_ids - space ID(s) of the rule that created this alert
const SPACE_IDS = exports.SPACE_IDS = `${KIBANA_NAMESPACE}.space_ids`;

// kibana.version - Kibana version that this alert was created
const VERSION = exports.VERSION = `${KIBANA_NAMESPACE}.version`;

// kibana.alert.action_group - framework action group ID for this alert
const ALERT_ACTION_GROUP = exports.ALERT_ACTION_GROUP = `${ALERT_NAMESPACE}.action_group`;

// kibana.alert.previous_action_group
const ALERT_PREVIOUS_ACTION_GROUP = exports.ALERT_PREVIOUS_ACTION_GROUP = `${ALERT_NAMESPACE}.previous_action_group`;

// kibana.alert.severity_improving
const ALERT_SEVERITY_IMPROVING = exports.ALERT_SEVERITY_IMPROVING = `${ALERT_NAMESPACE}.severity_improving`;

// kibana.alert.case_ids - array of cases associated with the alert
const ALERT_CASE_IDS = exports.ALERT_CASE_IDS = `${ALERT_NAMESPACE}.case_ids`;

// kibana.alert.duration.us - alert duration in microseconds - updated each execution
// that the alert is active
const ALERT_DURATION = exports.ALERT_DURATION = `${ALERT_NAMESPACE}.duration.us`;

// kibana.alert.end - timestamp when the alert is auto-recovered by the framework
const ALERT_END = exports.ALERT_END = `${ALERT_NAMESPACE}.end`;

// kibana.alert.flapping - whether the alert is currently in a flapping state
const ALERT_FLAPPING = exports.ALERT_FLAPPING = `${ALERT_NAMESPACE}.flapping`;

// kibana.alert.flapping_history - whether the alert is currently in a flapping state
const ALERT_FLAPPING_HISTORY = exports.ALERT_FLAPPING_HISTORY = `${ALERT_NAMESPACE}.flapping_history`;

// kibana.alert.maintenance_window_ids - IDs of maintenance windows that are affecting this alert
const ALERT_MAINTENANCE_WINDOW_IDS = exports.ALERT_MAINTENANCE_WINDOW_IDS = `${ALERT_NAMESPACE}.maintenance_window_ids`;

// kibana.alert.consecutive_matches - count of consecutive times the alert has been active
const ALERT_CONSECUTIVE_MATCHES = exports.ALERT_CONSECUTIVE_MATCHES = `${ALERT_NAMESPACE}.consecutive_matches`;

// kibana.alert.pending_recovered_count - count of consecutive times the alert has been recovered
const ALERT_PENDING_RECOVERED_COUNT = exports.ALERT_PENDING_RECOVERED_COUNT = `${ALERT_NAMESPACE}.pending_recovered_count`;

// kibana.alert.instance.id - alert ID, also known as alert instance ID
const ALERT_INSTANCE_ID = exports.ALERT_INSTANCE_ID = `${ALERT_NAMESPACE}.instance.id`;

// kibana.alert.last_detected - timestamp when the alert was last seen
const ALERT_LAST_DETECTED = exports.ALERT_LAST_DETECTED = `${ALERT_NAMESPACE}.last_detected`;

// kiana.alert.intended_timestamp - timestamp when the alert was intended to be detected, useful for backfilling
const ALERT_INTENDED_TIMESTAMP = exports.ALERT_INTENDED_TIMESTAMP = `${ALERT_NAMESPACE}.intended_timestamp`;

// kibana.alert.reason - human readable reason that this alert is active
const ALERT_REASON = exports.ALERT_REASON = `${ALERT_NAMESPACE}.reason`;

// kibana.alert.start - timestamp when the alert is first active
const ALERT_START = exports.ALERT_START = `${ALERT_NAMESPACE}.start`;

// kibana.alert.updated_at - timestamp when the alert was last updated
const ALERT_UPDATED_AT = exports.ALERT_UPDATED_AT = `${ALERT_NAMESPACE}.updated_at`;

// kibana.alert.updated_by.user.id - user id of the user that last updated the alert
const ALERT_UPDATED_BY_USER_ID = exports.ALERT_UPDATED_BY_USER_ID = `${ALERT_NAMESPACE}.updated_by.user.id`;

// kibana.alert.updated_by.user.name - user name of the user that last updated the alert
const ALERT_UPDATED_BY_USER_NAME = exports.ALERT_UPDATED_BY_USER_NAME = `${ALERT_NAMESPACE}.updated_by.user.name`;

// kibana.alert.status - active/recovered status of alert
const ALERT_STATUS = exports.ALERT_STATUS = `${ALERT_NAMESPACE}.status`;

// kibana.alert.time_range - time range of alert from kibana.alert.start to now
const ALERT_TIME_RANGE = exports.ALERT_TIME_RANGE = `${ALERT_NAMESPACE}.time_range`;

// kibana.alert.uuid - unique ID for the active span of this alert
const ALERT_UUID = exports.ALERT_UUID = `${ALERT_NAMESPACE}.uuid`;

// kibana.alert.workflow_status - open/closed status of alert
const ALERT_WORKFLOW_STATUS = exports.ALERT_WORKFLOW_STATUS = `${ALERT_NAMESPACE}.workflow_status`;

// kibana.alert.workflow_tags - user workflow alert tags
const ALERT_WORKFLOW_TAGS = exports.ALERT_WORKFLOW_TAGS = `${ALERT_NAMESPACE}.workflow_tags`;

// kibana.alert.workflow_assignee_ids - user workflow alert assignees
const ALERT_WORKFLOW_ASSIGNEE_IDS = exports.ALERT_WORKFLOW_ASSIGNEE_IDS = `${ALERT_NAMESPACE}.workflow_assignee_ids`;

// kibana.alert.rule.category - rule type name for rule that generated this alert
const ALERT_RULE_CATEGORY = exports.ALERT_RULE_CATEGORY = `${ALERT_RULE_NAMESPACE}.category`;

// kibana.alert.rule.consumer - consumer for rule that generated this alert
const ALERT_RULE_CONSUMER = exports.ALERT_RULE_CONSUMER = `${ALERT_RULE_NAMESPACE}.consumer`;

// kibana.alert.rule.execution.timestamp - timestamp of the rule execution that generated this alert
const ALERT_RULE_EXECUTION_TIMESTAMP = exports.ALERT_RULE_EXECUTION_TIMESTAMP = `${ALERT_RULE_NAMESPACE}.execution.timestamp`;

// kibana.alert.rule.execution.uuid - unique ID for the rule execution that generated this alert
const ALERT_RULE_EXECUTION_UUID = exports.ALERT_RULE_EXECUTION_UUID = `${ALERT_RULE_NAMESPACE}.execution.uuid`;

// kibana.alert.rule.name - rule name for rule that generated this alert
const ALERT_RULE_NAME = exports.ALERT_RULE_NAME = `${ALERT_RULE_NAMESPACE}.name`;

// kibana.alert.rule.parameters - rule parameters for rule that generated this alert
const ALERT_RULE_PARAMETERS = exports.ALERT_RULE_PARAMETERS = `${ALERT_RULE_NAMESPACE}.parameters`;

// kibana.alert.rule.producer - rule type producer for rule that generated this alert
const ALERT_RULE_PRODUCER = exports.ALERT_RULE_PRODUCER = `${ALERT_RULE_NAMESPACE}.producer`;

// kibana.alert.rule.revision - current revision of the rule that generated this alert
const ALERT_RULE_REVISION = exports.ALERT_RULE_REVISION = `${ALERT_RULE_NAMESPACE}.revision`;

// kibana.alert.rule.tags - rule tags for rule that generated this alert
const ALERT_RULE_TAGS = exports.ALERT_RULE_TAGS = `${ALERT_RULE_NAMESPACE}.tags`;

// kibana.alert.rule_type_id - rule type id for rule that generated this alert
const ALERT_RULE_TYPE_ID = exports.ALERT_RULE_TYPE_ID = `${ALERT_RULE_NAMESPACE}.rule_type_id`;

// kibana.alert.url - url which will redirect users to a page related to the given alert
const ALERT_URL = exports.ALERT_URL = `${ALERT_NAMESPACE}.url`;

// kibana.alert.rule.uuid - rule ID for rule that generated this alert
const ALERT_RULE_UUID = exports.ALERT_RULE_UUID = `${ALERT_RULE_NAMESPACE}.uuid`;

// kibana.alert.rule.execution.type - rule execution type for rule that generated this alert (manual /scheduled)
const ALERT_RULE_EXECUTION_TYPE = exports.ALERT_RULE_EXECUTION_TYPE = `${ALERT_RULE_NAMESPACE}.execution.type`;
const ALERT_SCHEDULED_ACTION_GROUP = exports.ALERT_SCHEDULED_ACTION_GROUP = `${ALERT_SCHEDULED_ACTION_NAMESPACE}.group`;
const ALERT_SCHEDULED_ACTION_DATE = exports.ALERT_SCHEDULED_ACTION_DATE = `${ALERT_SCHEDULED_ACTION_NAMESPACE}.date`;
const ALERT_SCHEDULED_ACTION_THROTTLING = exports.ALERT_SCHEDULED_ACTION_THROTTLING = `${ALERT_SCHEDULED_ACTION_NAMESPACE}.throttling`;

// kibana.alert.index_pattern - index pattern for the alert
const ALERT_INDEX_PATTERN = exports.ALERT_INDEX_PATTERN = `${ALERT_NAMESPACE}.index_pattern`;
const namespaces = {
  KIBANA_NAMESPACE,
  ALERT_NAMESPACE,
  ALERT_RULE_NAMESPACE,
  ALERT_STATE_NAMESPACE
};
const fields = exports.fields = {
  ALERT_ACTION_GROUP,
  ALERT_CASE_IDS,
  ALERT_DURATION,
  ALERT_END,
  ALERT_FLAPPING,
  ALERT_FLAPPING_HISTORY,
  ALERT_MAINTENANCE_WINDOW_IDS,
  ALERT_PENDING_RECOVERED_COUNT,
  ALERT_CONSECUTIVE_MATCHES,
  ALERT_INSTANCE_ID,
  ALERT_INDEX_PATTERN,
  ALERT_LAST_DETECTED,
  ALERT_PREVIOUS_ACTION_GROUP,
  ALERT_REASON,
  ALERT_RULE_CATEGORY,
  ALERT_RULE_CONSUMER,
  ALERT_RULE_EXECUTION_TIMESTAMP,
  ALERT_RULE_EXECUTION_TYPE,
  ALERT_INTENDED_TIMESTAMP,
  ALERT_RULE_EXECUTION_UUID,
  ALERT_RULE_NAME,
  ALERT_RULE_PARAMETERS,
  ALERT_RULE_PRODUCER,
  ALERT_RULE_REVISION,
  ALERT_RULE_TAGS,
  ALERT_RULE_TYPE_ID,
  ALERT_RULE_UUID,
  ALERT_SEVERITY_IMPROVING,
  ALERT_START,
  ALERT_UPDATED_AT,
  ALERT_UPDATED_BY_USER_ID,
  ALERT_UPDATED_BY_USER_NAME,
  ALERT_STATUS,
  ALERT_TIME_RANGE,
  ALERT_URL,
  ALERT_UUID,
  ALERT_WORKFLOW_ASSIGNEE_IDS,
  ALERT_WORKFLOW_STATUS,
  ALERT_WORKFLOW_TAGS,
  ALERT_SCHEDULED_ACTION_GROUP,
  ALERT_SCHEDULED_ACTION_DATE,
  ALERT_SCHEDULED_ACTION_THROTTLING,
  SPACE_IDS,
  TIMESTAMP,
  VERSION
};