"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformScheduledReport = exports.transformEmailNotification = exports.jobHasIssues = exports.guessAppIconTypeFromObjectType = exports.getDisplayNameFromObjectType = void 0;
var _lodash = require("lodash");
var _reportingCommon = require("@kbn/reporting-common");
var _rrule = require("@kbn/rrule");
var _constants = require("@kbn/response-ops-recurring-schedule-form/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is not the most forward-compatible way of mapping to an {@link IconType} for an application.
 *
 * Ideally apps using reporting should send some metadata for the icon type they want - this is how
 * the saved objects management UI handles icons at the moment.
 */
const guessAppIconTypeFromObjectType = type => {
  switch (type) {
    case 'search':
      return 'discoverApp';
    case 'dashboard':
      return 'dashboardApp';
    case 'visualization':
      return 'visualizeApp';
    case 'canvas workpad':
      return 'canvasApp';
    case 'lens':
      return 'lensApp';
    default:
      return 'apps';
  }
};
exports.guessAppIconTypeFromObjectType = guessAppIconTypeFromObjectType;
const getDisplayNameFromObjectType = type => {
  switch (type) {
    case 'search':
      return 'Discover';
    default:
      return (0, _lodash.capitalize)(type);
  }
};
exports.getDisplayNameFromObjectType = getDisplayNameFromObjectType;
const jobHasIssues = job => {
  return Boolean(job.getWarnings()) || [_reportingCommon.JOB_STATUS.WARNINGS, _reportingCommon.JOB_STATUS.FAILED].some(status => job.status === status);
};
exports.jobHasIssues = jobHasIssues;
const isCustomRrule = rRule => {
  const freq = rRule.freq;
  // interval is greater than 1
  if (rRule.interval && rRule.interval > 1) {
    return true;
  }
  // frequency is daily and no weekdays are selected
  if (freq && freq === _rrule.Frequency.DAILY && !rRule.byweekday) {
    return true;
  }
  // frequency is weekly and there are multiple weekdays selected
  if (freq && freq === _rrule.Frequency.WEEKLY && rRule.byweekday && rRule.byweekday.length > 1) {
    return true;
  }
  // frequency is monthly and by month day is selected
  if (freq && freq === _rrule.Frequency.MONTHLY && rRule.bymonthday) {
    return true;
  }
  return false;
};
const transformScheduledReport = report => {
  var _rRule$byhour, _rRule$byminute, _notification$email, _notification$email2, _notification$email3, _notification$email$s, _notification$email4, _notification$email$m, _notification$email5;
  const {
    title,
    schedule,
    notification,
    id
  } = report;
  const rRule = schedule.rrule;
  const isCustomFrequency = isCustomRrule(rRule);
  const frequency = rRule.freq;
  const recurringSchedule = {
    frequency: isCustomFrequency ? 'CUSTOM' : frequency,
    interval: rRule.interval,
    ends: _constants.RecurrenceEnd.NEVER
  };
  if (isCustomFrequency) {
    recurringSchedule.customFrequency = frequency;
  }
  if (frequency !== _rrule.Frequency.MONTHLY && rRule.byweekday) {
    recurringSchedule.byweekday = rRule.byweekday.reduce((acc, day) => {
      const isoWeekDay = _constants.RRULE_TO_ISO_WEEKDAYS[day];
      if (isoWeekDay != null) {
        acc[isoWeekDay] = true;
      }
      return acc;
    }, {});
  }
  if (frequency === _rrule.Frequency.MONTHLY) {
    var _rRule$byweekday, _rRule$bymonthday;
    if ((_rRule$byweekday = rRule.byweekday) !== null && _rRule$byweekday !== void 0 && _rRule$byweekday.length) {
      recurringSchedule.bymonth = 'weekday';
      recurringSchedule.bymonthweekday = rRule.byweekday[0];
    } else if ((_rRule$bymonthday = rRule.bymonthday) !== null && _rRule$bymonthday !== void 0 && _rRule$bymonthday.length) {
      recurringSchedule.bymonth = 'day';
      recurringSchedule.bymonthday = rRule.bymonthday[0];
    }
  }
  if ((_rRule$byhour = rRule.byhour) !== null && _rRule$byhour !== void 0 && _rRule$byhour.length && (_rRule$byminute = rRule.byminute) !== null && _rRule$byminute !== void 0 && _rRule$byminute.length) {
    recurringSchedule.byhour = rRule.byhour[0];
    recurringSchedule.byminute = rRule.byminute[0];
  }
  return {
    id,
    title,
    recurringSchedule,
    // TODO dtstart should be required
    startDate: rRule.dtstart,
    reportTypeId: report.jobtype,
    timezone: rRule.tzid,
    recurring: true,
    sendByEmail: Boolean(notification === null || notification === void 0 ? void 0 : notification.email),
    emailRecipients: [...((notification === null || notification === void 0 ? void 0 : (_notification$email = notification.email) === null || _notification$email === void 0 ? void 0 : _notification$email.to) || [])],
    emailCcRecipients: [...((notification === null || notification === void 0 ? void 0 : (_notification$email2 = notification.email) === null || _notification$email2 === void 0 ? void 0 : _notification$email2.cc) || [])],
    emailBccRecipients: [...((notification === null || notification === void 0 ? void 0 : (_notification$email3 = notification.email) === null || _notification$email3 === void 0 ? void 0 : _notification$email3.bcc) || [])],
    emailSubject: (_notification$email$s = notification === null || notification === void 0 ? void 0 : (_notification$email4 = notification.email) === null || _notification$email4 === void 0 ? void 0 : _notification$email4.subject) !== null && _notification$email$s !== void 0 ? _notification$email$s : '',
    emailMessage: (_notification$email$m = notification === null || notification === void 0 ? void 0 : (_notification$email5 = notification.email) === null || _notification$email5 === void 0 ? void 0 : _notification$email5.message) !== null && _notification$email$m !== void 0 ? _notification$email$m : ''
  };
};
exports.transformScheduledReport = transformScheduledReport;
const transformEmailNotification = ({
  emailRecipients,
  emailCcRecipients,
  emailBccRecipients,
  emailSubject,
  emailMessage
}) => {
  return {
    to: emailRecipients,
    cc: emailCcRecipients,
    bcc: emailBccRecipients,
    subject: emailSubject,
    message: emailMessage
  };
};
exports.transformEmailNotification = transformEmailNotification;