"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNMET_REPORTING_PREREQUISITES_TITLE = exports.UNMET_REPORTING_PREREQUISITES_MESSAGE = exports.TECH_PREVIEW_LABEL = exports.TECH_PREVIEW_DESCRIPTION = exports.SCHEDULE_EXPORT_BUTTON_LABEL = exports.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_TITLE = exports.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_MESSAGE = exports.SCHEDULED_REPORT_NO_REPORT_TYPES_TITLE = exports.SCHEDULED_REPORT_NO_REPORT_TYPES_MESSAGE = exports.SCHEDULED_REPORT_FORM_TIMEZONE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_TIMEZONE_LABEL = exports.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_TITLE = exports.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_MESSAGE = exports.SCHEDULED_REPORT_FORM_START_DATE_TOO_EARLY_MESSAGE = exports.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_START_DATE_LABEL = exports.SCHEDULED_REPORT_FORM_SEND_BY_EMAIL_LABEL = exports.SCHEDULED_REPORT_FORM_SCHEDULE_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_RECURRING_LABEL = exports.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_LABEL = exports.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_DESCRIPTION = exports.SCHEDULED_REPORT_FORM_NO_USER_EMAIL_HINT = exports.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_TITLE = exports.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_MESSAGE = exports.SCHEDULED_REPORT_FORM_FILE_TYPE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_FILE_TYPE_LABEL = exports.SCHEDULED_REPORT_FORM_FILE_NAME_SUFFIX = exports.SCHEDULED_REPORT_FORM_FILE_NAME_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_FILE_NAME_LABEL = exports.SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE = exports.SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE = exports.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_DESCRIPTION = exports.SCHEDULED_REPORT_FORM_EMAIL_SUBJECT_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_SHOW_CC_BCC_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_TITLE = exports.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_MESSAGE = exports.SCHEDULED_REPORT_FORM_EMAIL_SELF_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_CC_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_BCC_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_DETAILS_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_CREATE_EMAIL_CONNECTOR_LABEL = exports.SCHEDULED_REPORT_FLYOUT_TITLE = exports.SCHEDULED_REPORT_FLYOUT_SUBMIT_BUTTON_LABEL = exports.SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL = exports.REPORTING_PAGE_LINK_TEXT = exports.CANNOT_LOAD_REPORTING_HEALTH_TITLE = exports.CANNOT_LOAD_REPORTING_HEALTH_MESSAGE = void 0;
exports.getInvalidEmailAddress = getInvalidEmailAddress;
exports.getNotAllowedEmailAddress = getNotAllowedEmailAddress;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULE_EXPORT_BUTTON_LABEL = exports.SCHEDULE_EXPORT_BUTTON_LABEL = _i18n.i18n.translate('xpack.reporting.scheduleExportButtonLabel', {
  defaultMessage: 'Schedule export'
});
const SCHEDULED_REPORT_FLYOUT_TITLE = exports.SCHEDULED_REPORT_FLYOUT_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingFlyout.title', {
  defaultMessage: 'Schedule exports'
});
const SCHEDULED_REPORT_FLYOUT_SUBMIT_BUTTON_LABEL = exports.SCHEDULED_REPORT_FLYOUT_SUBMIT_BUTTON_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingFlyout.submitButtonLabel', {
  defaultMessage: 'Schedule exports'
});
const SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL = exports.SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingFlyout.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const SCHEDULED_REPORT_FORM_FILE_NAME_LABEL = exports.SCHEDULED_REPORT_FORM_FILE_NAME_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.fileNameLabel', {
  defaultMessage: 'Report name'
});
const SCHEDULED_REPORT_FORM_FILE_NAME_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_FILE_NAME_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.fileNameRequiredMessage', {
  defaultMessage: 'Report file name is required'
});
const SCHEDULED_REPORT_FORM_FILE_TYPE_LABEL = exports.SCHEDULED_REPORT_FORM_FILE_TYPE_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.fileTypeLabel', {
  defaultMessage: 'File type'
});
const SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_LABEL = exports.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.optimizedForPrintingLabel', {
  defaultMessage: 'Print format'
});
const SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_DESCRIPTION = exports.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_DESCRIPTION = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.optimizedForDescription', {
  defaultMessage: 'Uses multiple pages, showing at most 2 visualizations per page'
});
const SCHEDULED_REPORT_FORM_FILE_TYPE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_FILE_TYPE_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.fileTypeRequiredMessage', {
  defaultMessage: 'File type is required'
});
const SCHEDULED_REPORT_FORM_START_DATE_LABEL = exports.SCHEDULED_REPORT_FORM_START_DATE_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.startDateLabel', {
  defaultMessage: 'Date'
});
const SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.startDateRequiredMessage', {
  defaultMessage: 'Date is required'
});
const SCHEDULED_REPORT_FORM_START_DATE_TOO_EARLY_MESSAGE = exports.SCHEDULED_REPORT_FORM_START_DATE_TOO_EARLY_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.startDateTooEarlyMessage', {
  defaultMessage: 'Start date must be in the future'
});
const SCHEDULED_REPORT_FORM_TIMEZONE_LABEL = exports.SCHEDULED_REPORT_FORM_TIMEZONE_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.timezoneLabel', {
  defaultMessage: 'Timezone'
});
const SCHEDULED_REPORT_FORM_TIMEZONE_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_TIMEZONE_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.timezoneRequiredMessage', {
  defaultMessage: 'Timezone is required'
});
const SCHEDULED_REPORT_FORM_FILE_NAME_SUFFIX = exports.SCHEDULED_REPORT_FORM_FILE_NAME_SUFFIX = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.fileNameSuffix', {
  defaultMessage: '+ @timestamp'
});
const SCHEDULED_REPORT_FORM_DETAILS_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_DETAILS_SECTION_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.detailsSectionTitle', {
  defaultMessage: 'Details'
});
const SCHEDULED_REPORT_FORM_SCHEDULE_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_SCHEDULE_SECTION_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.scheduleSectionTitle', {
  defaultMessage: 'Schedule'
});
const SCHEDULED_REPORT_FORM_EXPORTS_SECTION_TITLE = exports.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.exportsSectionTitle', {
  defaultMessage: 'Exports'
});
const SCHEDULED_REPORT_FORM_EXPORTS_SECTION_DESCRIPTION = exports.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_DESCRIPTION = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.exportsSectionDescription', {
  defaultMessage: "On the scheduled date, we'll create a snapshot of this data point and will post the downloadable report on the "
});
const REPORTING_PAGE_LINK_TEXT = exports.REPORTING_PAGE_LINK_TEXT = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.reportingPageLinkText', {
  defaultMessage: 'Reporting page'
});
const SCHEDULED_REPORT_FORM_RECURRING_LABEL = exports.SCHEDULED_REPORT_FORM_RECURRING_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.recurringLabel', {
  defaultMessage: 'Make recurring'
});
const SCHEDULED_REPORT_FORM_SEND_BY_EMAIL_LABEL = exports.SCHEDULED_REPORT_FORM_SEND_BY_EMAIL_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.sendByEmailLabel', {
  defaultMessage: 'Send by email'
});
const SCHEDULED_REPORT_FORM_NO_USER_EMAIL_HINT = exports.SCHEDULED_REPORT_FORM_NO_USER_EMAIL_HINT = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.noUserEmailHint', {
  defaultMessage: 'To receive reports by email, you must have an email address set in your user profile.'
});
const SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailRecipientsLabel', {
  defaultMessage: 'To'
});
const SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_REQUIRED_MESSAGE = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_REQUIRED_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailRecipientsRequiredMessage', {
  defaultMessage: 'Provide at least one recipient'
});
const SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_HINT = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailRecipientsHint', {
  defaultMessage: "We'll email the report to the addresses you specify here."
});
const SCHEDULED_REPORT_FORM_EMAIL_SELF_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_SELF_HINT = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailSelfHint', {
  defaultMessage: "We'll email the report to your address."
});
const SCHEDULED_REPORT_FORM_EMAIL_SHOW_CC_BCC_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_SHOW_CC_BCC_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailShowCcBccLabel', {
  defaultMessage: 'Cc Bcc'
});
const SCHEDULED_REPORT_FORM_EMAIL_CC_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_CC_RECIPIENTS_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailCcRecipientsLabel', {
  defaultMessage: 'Cc'
});
const SCHEDULED_REPORT_FORM_EMAIL_BCC_RECIPIENTS_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_BCC_RECIPIENTS_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailBccRecipientsLabel', {
  defaultMessage: 'Bcc'
});
const SCHEDULED_REPORT_FORM_EMAIL_SUBJECT_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_SUBJECT_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailSubjectLabel', {
  defaultMessage: 'Subject'
});
const SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_LABEL = exports.SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailMessageLabel', {
  defaultMessage: 'Message'
});
const SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_HINT = exports.SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_HINT = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailMessageHint', {
  defaultMessage: 'Supports Mustache variables and markdown formatting.'
});
const SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_TITLE = exports.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.missingEmailConnectorTitle', {
  defaultMessage: "Email connector hasn't been created yet"
});
const SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_MESSAGE = exports.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.missingEmailConnectorMessage', {
  defaultMessage: 'A default email connector must be configured in order to send notifications.'
});
const SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_TITLE = exports.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailSensitiveInfoTitle', {
  defaultMessage: 'Sensitive information'
});
const SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_MESSAGE = exports.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.emailSensitiveInfoMessage', {
  defaultMessage: 'Report may contain sensitive information'
});
const SCHEDULED_REPORT_FORM_SUCCESS_TOAST_TITLE = exports.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.successToastTitle', {
  defaultMessage: 'Export scheduled'
});
const SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_TITLE = exports.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.updateSuccessToastTitle', {
  defaultMessage: 'Scheduled report updated'
});
const SCHEDULED_REPORT_FORM_CREATE_EMAIL_CONNECTOR_LABEL = exports.SCHEDULED_REPORT_FORM_CREATE_EMAIL_CONNECTOR_LABEL = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.createEmailConnectorLabel', {
  defaultMessage: 'Create Email connector'
});
const SCHEDULED_REPORT_FORM_SUCCESS_TOAST_MESSAGE = exports.SCHEDULED_REPORT_FORM_SUCCESS_TOAST_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.successToastMessage', {
  defaultMessage: 'Find your schedule information and your exports in the '
});
const SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_MESSAGE = exports.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.updateSuccessToastMessage', {
  defaultMessage: 'Your scheduled report was updated successfully.'
});
const SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE = exports.SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.failureToastTitle', {
  defaultMessage: 'Schedule error'
});
const SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE = exports.SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.failureToastMessage', {
  defaultMessage: 'Sorry, we couldn’t schedule your export. Please try again.'
});
const SCHEDULED_REPORT_NO_REPORT_TYPES_TITLE = exports.SCHEDULED_REPORT_NO_REPORT_TYPES_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.noReportTypesTitle', {
  defaultMessage: 'Scheduled reports are not supported here yet'
});
const SCHEDULED_REPORT_NO_REPORT_TYPES_MESSAGE = exports.SCHEDULED_REPORT_NO_REPORT_TYPES_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.noReportTypesMessage', {
  defaultMessage: 'Report types in this page are not supported for scheduled reports yet.'
});
const CANNOT_LOAD_REPORTING_HEALTH_TITLE = exports.CANNOT_LOAD_REPORTING_HEALTH_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.cannotLoadReportingHealthTitle', {
  defaultMessage: 'Cannot load reporting health'
});
const UNMET_REPORTING_PREREQUISITES_TITLE = exports.UNMET_REPORTING_PREREQUISITES_TITLE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.unmetReportingPrerequisitesTitle', {
  defaultMessage: 'Cannot schedule reports'
});
const UNMET_REPORTING_PREREQUISITES_MESSAGE = exports.UNMET_REPORTING_PREREQUISITES_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.unmetReportingPrerequisitesMessage', {
  defaultMessage: 'One or more prerequisites for scheduling reports was not met. Contact your administrator to know more.'
});
const CANNOT_LOAD_REPORTING_HEALTH_MESSAGE = exports.CANNOT_LOAD_REPORTING_HEALTH_MESSAGE = _i18n.i18n.translate('xpack.reporting.scheduledReportingForm.cannotLoadReportingHealthMessage', {
  defaultMessage: 'Reporting health is a prerequisite to create scheduled exports'
});
const TECH_PREVIEW_LABEL = exports.TECH_PREVIEW_LABEL = _i18n.i18n.translate('xpack.reporting.technicalPreviewBadgeLabel', {
  defaultMessage: 'Technical preview'
});
const TECH_PREVIEW_DESCRIPTION = exports.TECH_PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.reporting.technicalPreviewBadgeDescription', {
  defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
});
function getInvalidEmailAddress(email) {
  return _i18n.i18n.translate('xpack.reporting.components.email.error.invalidEmail', {
    defaultMessage: 'Email address {email} is not valid',
    values: {
      email
    }
  });
}
function getNotAllowedEmailAddress(email) {
  return _i18n.i18n.translate('xpack.reporting.components.email.error.notAllowed', {
    defaultMessage: 'Email address {email} is not allowed',
    values: {
      email
    }
  });
}