"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldRegisterScheduledReportShareIntegration = exports.createScheduledReportShareIntegration = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reportingCommon = require("@kbn/reporting-common");
var _use_get_reporting_health_query = require("../hooks/use_get_reporting_health_query");
var _query_client = require("../../query_client");
var _translations = require("../translations");
var _get_reporting_health = require("../apis/get_reporting_health");
var _report_params = require("../report_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/integrations/scheduled_report_share_integration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const shouldRegisterScheduledReportShareIntegration = async http => {
  const {
    isSufficientlySecure,
    hasPermanentEncryptionKey
  } = await _query_client.queryClient.fetchQuery({
    queryKey: (0, _use_get_reporting_health_query.getKey)(),
    queryFn: () => (0, _get_reporting_health.getReportingHealth)({
      http
    })
  });
  return isSufficientlySecure && hasPermanentEncryptionKey;
};
exports.shouldRegisterScheduledReportShareIntegration = shouldRegisterScheduledReportShareIntegration;
const createScheduledReportShareIntegration = ({
  apiClient,
  services
}) => {
  return {
    id: 'scheduledReports',
    groupId: 'exportDerivatives',
    getShareIntegrationConfig: async shareOpts => {
      const {
        ScheduledReportFlyoutShareWrapper
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/scheduled_report_flyout_share_wrapper')));
      const {
        sharingData
      } = shareOpts;
      return {
        label: ({
          openFlyout
        }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          iconType: "calendar",
          onClick: openFlyout,
          "data-test-subj": "scheduleExport",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 55,
            columnNumber: 11
          }
        }, _translations.SCHEDULE_EXPORT_BUTTON_LABEL),
        shouldRender: ({
          availableExportItems
        }) => {
          const supportedExportItemsForScheduling = availableExportItems.filter(exportItem => _report_params.supportedReportTypes.includes(exportItem.config.exportType));
          return supportedExportItemsForScheduling.length > 0;
        },
        flyoutContent: ({
          closeFlyout
        }) => {
          return /*#__PURE__*/_react.default.createElement(ScheduledReportFlyoutShareWrapper, {
            apiClient: apiClient,
            services: services,
            sharingData: sharingData,
            onClose: closeFlyout,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 67,
              columnNumber: 13
            }
          });
        },
        flyoutSizing: {
          size: 'm',
          maxWidth: 500
        }
      };
    },
    prerequisiteCheck: ({
      license
    }) => {
      if (!license || !license.type) {
        return false;
      }
      return _reportingCommon.SCHEDULED_REPORT_VALID_LICENSES.includes(license.type);
    }
  };
};
exports.createScheduledReportShareIntegration = createScheduledReportShareIntegration;