"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ReportingTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRouterDom = require("react-router-dom");
var _reportingPublic = require("@kbn/reporting-public");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _reportingCommon = require("@kbn/reporting-common");
var _constants = require("../../constants");
var _report_exports_table = _interopRequireDefault(require("./report_exports_table"));
var _report_schedules_table = _interopRequireDefault(require("./report_schedules_table"));
var _license_prompt = require("./license_prompt");
var _translations = require("../translations");
var _ilm_policy_wrapper = _interopRequireDefault(require("./ilm_policy_wrapper"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/reporting_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReportingTabs = ({
  config
}) => {
  const {
    section
  } = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    apiClient
  } = (0, _reportingPublic.useInternalApiClient)();
  const {
    services: {
      application: {
        capabilities,
        navigateToApp,
        navigateToUrl
      },
      http,
      notifications,
      share: {
        url: urlService
      },
      license$
    }
  } = (0, _reportingPublic.useKibana)();
  const license = (0, _useObservable.default)(license$ !== null && license$ !== void 0 ? license$ : new _rxjs.Observable(), null);
  const licensingInfo = (0, _react.useMemo)(() => {
    if (!license) {
      return {
        enableLinks: false,
        showLinks: false
      };
    }
    if (!license || !license.type) {
      return {
        showLinks: true,
        enableLinks: false,
        message: 'You cannot use Reporting because license information is not available at this time.'
      };
    }
    if (!license.isActive) {
      return {
        showLinks: true,
        enableLinks: false,
        message: 'You cannot use Reporting because your ${license.type} license has expired.'
      };
    }
    if (!_reportingCommon.SCHEDULED_REPORT_VALID_LICENSES.includes(license.type)) {
      return {
        showLinks: false,
        enableLinks: false,
        message: 'Your {licenseType} license does not support Scheduled reports. Please upgrade your license.'
      };
    }
    return {
      showLinks: true,
      enableLinks: true
    };
  }, [license]);
  const tabs = [{
    id: 'exports',
    name: _i18n.i18n.translate('xpack.reporting.tabs.exports', {
      defaultMessage: 'Exports'
    })
  }, {
    id: 'schedules',
    name: _i18n.i18n.translate('xpack.reporting.tabs.schedules', {
      defaultMessage: 'Schedules'
    }),
    isBeta: true
  }];
  const {
    enableLinks,
    showLinks
  } = licensingInfo;
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    paddingSize: "none",
    bottomBorder: true,
    rightSideItems: config.statefulSettings.enabled ? [/*#__PURE__*/_react.default.createElement(_ilm_policy_wrapper.default, {
      config: config,
      apiClient: apiClient,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 16
      }
    })] : [],
    "data-test-subj": "reportingPageHeader",
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.reports.titleStateful",
      defaultMessage: "Reporting",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.reporting.reports.subtitleStateful",
      defaultMessage: "Get reports generated in Kibana applications.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }),
    tabs: tabs.map(({
      id,
      name,
      isBeta = false
    }) => ({
      label: !isBeta ? name : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        className: "eui-alignMiddle",
        size: "s",
        iconType: "flask",
        label: _translations.TECH_PREVIEW_LABEL,
        "aria-label": _translations.TECH_PREVIEW_LABEL,
        tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 15
        }
      })),
      onClick: () => onSectionChange(id),
      isSelected: id === section,
      key: id,
      'data-test-subj': `reportingTabs-${id}`
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.REPORTING_EXPORTS_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: 'xl',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 33
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_report_exports_table.default, {
      apiClient: apiClient,
      toasts: notifications.toasts,
      license$: license$,
      config: config,
      capabilities: capabilities,
      redirect: navigateToApp,
      navigateToUrl: navigateToUrl,
      urlService: urlService,
      http: http,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.REPORTING_SCHEDULES_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: 'xl',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 33
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    }, enableLinks && showLinks ? /*#__PURE__*/_react.default.createElement(_report_schedules_table.default, {
      apiClient: apiClient,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ReportingTabs = ReportingTabs;