"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterTable = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../store/actions");
var _remote_cluster_table = require("./remote_cluster_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @type {import('react-redux').MapDispatchToProps<any, any>} */
const mapDispatchToProps = dispatch => {
  return {
    openDetailPanel: clusterName => {
      dispatch((0, _actions.openDetailPanel)({
        name: clusterName
      }));
    }
  };
};

/**
 * @type {import('react-redux').ConnectedComponent<typeof RemoteClusterTableComponent, {}>}
 */
const RemoteClusterTable = exports.RemoteClusterTable = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(_remote_cluster_table.RemoteClusterTable);