"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackTraces = StackTraces;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _stacked_bar_chart = require("../stacked_bar_chart");
var _chart_grid = require("../chart_grid");
var _use_async = require("../../hooks/use_async");
var _async_component = require("../async_component");
var _subchart = require("../subchart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/stack_traces/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const displayOptions = [{
  id: _profilingUtils.StackTracesDisplayOption.StackTraces,
  iconType: 'visLine',
  label: _i18n.i18n.translate('xpack.profiling.stackTracesView.stackTracesCountButton', {
    defaultMessage: 'Stack traces'
  })
}, {
  id: _profilingUtils.StackTracesDisplayOption.Percentage,
  iconType: 'percent',
  label: _i18n.i18n.translate('xpack.profiling.stackTracesView.percentagesButton', {
    defaultMessage: 'Percentages'
  })
}];
function StackTraces({
  type,
  state,
  displayOption,
  onChangeDisplayOption,
  onStackedBarChartBrushEnd,
  limit,
  onShowMoreClick,
  onChartClick
}) {
  var _state$data$charts, _state$data, _charts$;
  const charts = (_state$data$charts = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.charts) !== null && _state$data$charts !== void 0 ? _state$data$charts : [];
  const isTracesType = type === _profilingUtils.TopNType.Traces;
  const [selectedSubchart, setSelectedSubchart] = (0, _react.useState)(undefined);
  const isExecutableType = type === _profilingUtils.TopNType.Executables;
  const displayAgentCallout = charts.length === 1 && ((_charts$ = charts[0]) === null || _charts$ === void 0 ? void 0 : _charts$.Category) === 'Other';
  function handleChartClick(selectedChart) {
    // When clicking on the charts on the Traces view, the flyout must open
    if (type === _profilingUtils.TopNType.Traces) {
      setSelectedSubchart(selectedChart);
    } else {
      onChartClick(selectedChart.Category);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, state.status === _use_async.AsyncStatus.Settled && isExecutableType && displayAgentCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "warning",
    "data-test-subj": "stackTracesAgentCallout",
    title: _i18n.i18n.translate('xpack.profiling.stackTraces.euiCallOut.wrongAgentTitle', {
      defaultMessage: 'No executable names available'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.profiling.stackTraces.euiCallOut.wrongAgentMessage', {
    defaultMessage: 'This might be due to data from agents prior to v9.1.0 or due to data from OpenTelemetry agents that do not send executable names.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "stackTracesChartPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "stackTracesDisplayOptionButtonGroup",
    idSelected: displayOption,
    type: "single",
    onChange: nextValue => {
      onChangeDisplayOption(nextValue);
    },
    options: displayOptions,
    legend: _i18n.i18n.translate('xpack.profiling.stackTracesView.displayOptionLegend', {
      defaultMessage: 'Display option'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "xl"
  }, state, {
    style: {
      height: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_stacked_bar_chart.StackedBarChart, {
    height: 400,
    charts: charts,
    asPercentages: displayOption === _profilingUtils.StackTracesDisplayOption.Percentage,
    onBrushEnd: onStackedBarChartBrushEnd,
    showFrames: isTracesType,
    onClick: handleChartClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({
    size: "m"
  }, state, {
    style: {
      minHeight: 200
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    "data-test-subj": "stackTracesTopLabel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.profiling.chartGrid.h1.topLabel', {
    defaultMessage: 'Top {size}',
    values: {
      size: onShowMoreClick ? charts.length : Math.min(limit, charts.length)
    }
  }))), /*#__PURE__*/_react.default.createElement(_chart_grid.ChartGrid, {
    charts: charts,
    limit: limit,
    showFrames: isTracesType,
    onChartClick: handleChartClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  })))), onShowMoreClick && charts.length > limit ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingStackTracesViewShowMoreButton",
    onClick: () => onShowMoreClick(limit + 10),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.profiling.stackTracesView.showMoreButton', {
    defaultMessage: 'Show more'
  }))) : null), selectedSubchart && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "stackTracesFlyout",
    "aria-label": _i18n.i18n.translate('xpack.profiling.stackTraces.flyout.ariaLabel', {
      defaultMessage: 'Stack trace details'
    }),
    onClose: () => {
      setSelectedSubchart(undefined);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_subchart.SubChart, {
    style: {
      overflow: 'auto'
    },
    index: selectedSubchart.Index,
    color: selectedSubchart.Color,
    category: selectedSubchart.Category,
    label: selectedSubchart.Label,
    percentage: selectedSubchart.Percentage,
    metadata: selectedSubchart.Metadata,
    height: 200,
    data: selectedSubchart.Series,
    sample: null,
    showAxes: true,
    showFrames: isTracesType,
    padTitle: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })));
}