"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.uiActionsService = exports.setKibanaServices = exports.dataViewsService = exports.coreServices = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let coreServices = exports.coreServices = void 0;
let dataViewsService = exports.dataViewsService = void 0;
let uiActionsService = exports.uiActionsService = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const setKibanaServices = (kibanaCore, deps) => {
  exports.coreServices = coreServices = kibanaCore;
  exports.dataViewsService = dataViewsService = deps.dataViews;
  exports.uiActionsService = uiActionsService = deps.uiActions;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;