"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputPane = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _output_tab = require("./output_tab");
var _parameters_tab = require("./parameters_tab");
var _context_tab = require("./context_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/painless_lab/public/application/components/output_pane/output_pane.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const componentStyles = {
  rightPane: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.emptyShade,
    padding: euiTheme.size.s,
    borderLeft: euiTheme.border.thin,
    height: '100%'
  }),
  tabsStyles: (0, _react2.css)({
    display: 'flex',
    flexDirection: 'column',
    height: '100%',
    "[role='tabpanel']": {
      height: '100%',
      overflowY: 'auto'
    }
  })
};
const OutputPane = ({
  isLoading,
  response
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const outputTabLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }) : response && response.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.painlessLab.outputTabLabel', {
    defaultMessage: 'Output'
  })));
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.rightPane,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    css: styles.tabsStyles,
    "data-test-subj": isLoading ? `painlessTabs-loading` : `painlessTabs-loaded`,
    size: "s",
    tabs: [{
      id: 'output',
      // TODO: Currently this causes an Eui prop error because it is expecting string, but we give it React.ReactNode - should fix.
      name: outputTabLabel,
      content: /*#__PURE__*/_react.default.createElement(_output_tab.OutputTab, {
        response: response,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 22
        }
      })
    }, {
      id: 'parameters',
      name: _i18n.i18n.translate('xpack.painlessLab.parametersTabLabel', {
        defaultMessage: 'Parameters'
      }),
      content: /*#__PURE__*/_react.default.createElement(_parameters_tab.ParametersTab, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 22
        }
      })
    }, {
      id: 'context',
      name: _i18n.i18n.translate('xpack.painlessLab.contextTabLabel', {
        defaultMessage: 'Context'
      }),
      content: /*#__PURE__*/_react.default.createElement(_context_tab.ContextTab, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 22
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }));
};
exports.OutputPane = OutputPane;