"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentIdFromFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extracts agent ID from Elasticsearch search hit fields.
 * Handles both ECS formatted ['agent.id'] and legacy (agent_id) field formats.
 *
 * @param fields - The fields object from an Elasticsearch SearchHit
 * @returns The agent ID string if found, undefined otherwise
 *
 * @example
 * ```typescript
 * const agentId = getAgentIdFromFields(searchHit.fields);
 * ```
 */
const getAgentIdFromFields = fields => {
  var _ref, _fields$agentId, _fields$agent_id;
  if (!fields) return undefined;

  // Check ECS format first (preferred), then fall back to legacy format
  return (_ref = (_fields$agentId = fields['agent.id']) === null || _fields$agentId === void 0 ? void 0 : _fields$agentId[0]) !== null && _ref !== void 0 ? _ref : (_fields$agent_id = fields.agent_id) === null || _fields$agent_id === void 0 ? void 0 : _fields$agent_id[0];
};
exports.getAgentIdFromFields = getAgentIdFromFields;