"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _services = require("./services");
var _features = require("./features");
var _routes = require("./routes");
var _ui_settings = require("./ui_settings");
var _request_handler_context = require("./request_handler_context");
var _usage_counters = require("./telemetry/usage_counters");
var _tracking_service = require("./telemetry/tracking_service");
var _telemetry_collector = require("./telemetry/telemetry_collector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    // @ts-expect-error unused for now
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "serviceManager", new _services.ServiceManager());
    (0, _defineProperty2.default)(this, "usageCounter", void 0);
    (0, _defineProperty2.default)(this, "trackingService", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(coreSetup, setupDeps) {
    // Create usage counter for telemetry (if usageCollection is available)
    if (setupDeps.usageCollection) {
      this.usageCounter = (0, _usage_counters.createOnechatUsageCounter)(setupDeps.usageCollection);
      if (this.usageCounter) {
        this.trackingService = new _tracking_service.TrackingService(this.usageCounter, this.logger.get('telemetry'));
        (0, _telemetry_collector.registerTelemetryCollector)(setupDeps.usageCollection, this.logger.get('telemetry'));
      }
      this.logger.info('Onechat telemetry initialized');
    } else {
      this.logger.warn('Usage collection plugin not available, telemetry disabled');
    }
    const serviceSetups = this.serviceManager.setupServices({
      logger: this.logger.get('services'),
      workflowsManagement: setupDeps.workflowsManagement,
      trackingService: this.trackingService
    });
    (0, _features.registerFeatures)({
      features: setupDeps.features
    });
    (0, _ui_settings.registerUISettings)({
      uiSettings: coreSetup.uiSettings
    });
    (0, _request_handler_context.registerOnechatHandlerContext)({
      coreSetup
    });
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      coreSetup,
      logger: this.logger,
      pluginsSetup: setupDeps,
      getInternalServices: () => {
        const services = this.serviceManager.internalStart;
        if (!services) {
          throw new Error('getInternalServices called before service init');
        }
        return services;
      },
      trackingService: this.trackingService
    });
    return {
      tools: {
        register: serviceSetups.tools.register.bind(serviceSetups.tools)
      },
      agents: {
        register: serviceSetups.agents.register.bind(serviceSetups.agents)
      },
      attachments: {
        registerType: serviceSetups.attachments.registerType.bind(serviceSetups.attachments)
      }
    };
  }
  start({
    elasticsearch,
    security,
    uiSettings,
    savedObjects
  }, {
    inference,
    spaces
  }) {
    const startServices = this.serviceManager.startServices({
      logger: this.logger.get('services'),
      security,
      elasticsearch,
      inference,
      spaces,
      uiSettings,
      savedObjects,
      trackingService: this.trackingService
    });
    const {
      tools,
      runnerFactory
    } = startServices;
    const runner = runnerFactory.getRunner();
    return {
      tools: {
        getRegistry: ({
          request
        }) => tools.getRegistry({
          request
        }),
        execute: runner.runTool.bind(runner)
      }
    };
  }
  stop() {}
}
exports.OnechatPlugin = OnechatPlugin;