"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformWorkflowToolToFormData = exports.transformWorkflowFormDataForUpdate = exports.transformWorkflowFormDataForCreate = exports.transformFormDataToWorkflowTool = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformWorkflowToolToFormData = tool => {
  var _tool$configuration$w;
  return {
    toolId: tool.id,
    description: tool.description,
    workflow_id: tool.configuration.workflow_id,
    wait_for_completion: (_tool$configuration$w = tool.configuration.wait_for_completion) !== null && _tool$configuration$w !== void 0 ? _tool$configuration$w : true,
    labels: tool.tags,
    type: _onechatCommon.ToolType.workflow
  };
};
exports.transformWorkflowToolToFormData = transformWorkflowToolToFormData;
const transformFormDataToWorkflowTool = data => {
  return {
    id: data.toolId,
    description: data.description,
    readonly: false,
    configuration: {
      workflow_id: data.workflow_id,
      wait_for_completion: data.wait_for_completion
    },
    type: _onechatCommon.ToolType.workflow,
    tags: data.labels
  };
};
exports.transformFormDataToWorkflowTool = transformFormDataToWorkflowTool;
const transformWorkflowFormDataForCreate = data => {
  return (0, _lodash.omit)(transformFormDataToWorkflowTool(data), ['readonly']);
};
exports.transformWorkflowFormDataForCreate = transformWorkflowFormDataForCreate;
const transformWorkflowFormDataForUpdate = data => {
  return (0, _lodash.omit)(transformFormDataToWorkflowTool(data), ['id', 'type', 'readonly']);
};
exports.transformWorkflowFormDataForUpdate = transformWorkflowFormDataForUpdate;