"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storageKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const storageKeys = exports.storageKeys = {
  agentId: 'agentBuilder.agentId',
  lastUsedConnector: 'agentBuilder.lastUsedConnector',
  getLastConversationKey: (sessionTag, agentId) => {
    const tag = sessionTag || 'default';
    const agent = agentId || 'default';
    return `agentBuilder.lastConversation.${tag}.${agent}`;
  }
};