"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigationAbort = void 0;
var _react = require("react");
var _i18n = require("../utils/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that handles navigation abort confirmation when user tries to navigate away
 * while a chat request is in progress.
 *
 * When user confirms navigation, the request is aborted and the round is marked as aborted.
 * When user cancels, they stay on the page and the request continues.
 */
const useNavigationAbort = ({
  onAppLeave,
  isResponseLoading
}) => {
  const shouldAbortOnUnmountRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    onAppLeave(actions => {
      if (isResponseLoading) {
        shouldAbortOnUnmountRef.current = true;
        return actions.confirm(_i18n.labels.navigationAbort.message, _i18n.labels.navigationAbort.title, () => {}, _i18n.labels.navigationAbort.confirmButton, 'danger');
      }
      return actions.default();
    });
    return () => {
      onAppLeave(actions => actions.default());
    };
  }, [onAppLeave, isResponseLoading]);
};
exports.useNavigationAbort = useNavigationAbort;