"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConnectorSelection = useConnectorSelection;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_kibana = require("../use_kibana");
var _storage_keys = require("../../storage_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useConnectorSelection() {
  const {
    services: {
      settings
    }
  } = (0, _use_kibana.useKibana)();
  const [selectedConnector, setSelectedConnector] = (0, _useLocalStorage.default)(_storage_keys.storageKeys.lastUsedConnector);
  const defaultConnectorId = settings === null || settings === void 0 ? void 0 : settings.client.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR, undefined);
  const selectConnector = (0, _react.useCallback)(connectorId => {
    setSelectedConnector(connectorId);
  }, [setSelectedConnector]);
  return {
    selectedConnector,
    selectConnector,
    defaultConnectorId
  };
}