"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _use_list_workflows = require("../../../../../hooks/tools/use_list_workflows");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/workflow/workflow_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowPicker = () => {
  const {
    control,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      value,
      onChange,
      onBlur,
      name
    },
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'workflow_id',
    control
  });
  const {
    data: workflows,
    isLoading
  } = (0, _use_list_workflows.useListWorkflows)();
  const options = (0, _react.useMemo)(() => {
    return (workflows || []).map(workflow => ({
      label: workflow.name,
      value: workflow.id
    }));
  }, [workflows]);
  const selectedOptions = (0, _react.useMemo)(() => {
    if (!value) return [];
    const selectedWorkflow = workflows === null || workflows === void 0 ? void 0 : workflows.find(w => w.id === value);
    if (!selectedWorkflow) return [];
    return [{
      label: selectedWorkflow.name,
      value: selectedWorkflow.id
    }];
  }, [value, workflows]);
  const handleSelectionChange = async newSelectedOptions => {
    const selectedWorkflowId = newSelectedOptions.length > 0 ? newSelectedOptions[0].value : '';
    onChange(selectedWorkflowId);
    await trigger(name);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.onechat.tools.workflow.picker.placeholder', {
      defaultMessage: 'Select a workflow'
    }),
    options: options,
    fullWidth: true,
    selectedOptions: selectedOptions,
    onChange: handleSelectionChange,
    onBlur: onBlur,
    singleSelection: {
      asPlainText: false
    },
    isLoading: isLoading,
    isInvalid: fieldState.invalid,
    "data-test-subj": "onechatWorkflowPicker",
    "aria-label": _i18n.i18n.translate('xpack.onechat.tools.workflow.picker.ariaLabel', {
      defaultMessage: 'Workflow selection'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
};
exports.WorkflowPicker = WorkflowPicker;