"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSearchPattern = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _react2 = require("@emotion/react");
var _onechatCommon = require("@kbn/onechat-common");
var _i18n2 = require("../../../../../utils/i18n");
var _use_resolve_search_sources = require("../../../../../hooks/tools/use_resolve_search_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/index_search/index_search_pattern.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 5;
const IndexSearchPattern = () => {
  var _data$total;
  const {
    control,
    setValue,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    field: {
      ref,
      value,
      onChange,
      onBlur,
      name
    },
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'pattern',
    control
  });
  const patternValue = value !== null && value !== void 0 ? value : '';
  const hasQuery = patternValue.trim().length > 0;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  (0, _react.useEffect)(() => {
    setPageIndex(0);
  }, [patternValue]);
  const {
    data,
    isLoading
  } = (0, _use_resolve_search_sources.useIndexSearchSources)({
    pattern: patternValue
  });
  const items = (0, _react.useMemo)(() => {
    var _data$results;
    return hasQuery ? (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [] : [];
  }, [data, hasQuery]);
  const total = hasQuery ? (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0 : 0;
  const pageOfItems = (0, _react.useMemo)(() => {
    const start = pageIndex * pageSize;
    const end = start + pageSize;
    return items.slice(start, end);
  }, [items, pageIndex, pageSize]);
  const columns = [{
    field: 'type',
    name: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.typeCol', {
      defaultMessage: 'Target'
    }),
    width: '120px',
    render: type => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "onechatIndexPatternBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      }, type === _onechatCommon.EsResourceType.index ? _i18n2.labels.tools.indexTypeLabel : type === _onechatCommon.EsResourceType.alias ? _i18n2.labels.tools.aliasTypeLabel : type === _onechatCommon.EsResourceType.dataStream ? _i18n2.labels.tools.dataStreamTypeLabel : undefined);
    }
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.nameCol', {
      defaultMessage: 'Name'
    }),
    truncateText: true
  }, {
    name: '',
    width: '80px',
    actions: [{
      name: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.useAction', {
        defaultMessage: 'Use'
      }),
      description: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.useActionDesc', {
        defaultMessage: 'Use this value as the pattern'
      }),
      icon: 'plusInCircle',
      type: 'icon',
      onClick: async item => {
        setValue('pattern', item.name, {
          shouldDirty: true,
          shouldValidate: true
        });
        await trigger('pattern');
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: name,
    value: patternValue,
    onChange: onChange,
    onBlur: onBlur,
    inputRef: ref,
    isInvalid: fieldState.invalid,
    "aria-label": _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.inputAriaLabel', {
      defaultMessage: 'Index pattern'
    }),
    "data-test-subj": "onechatIndexPatternInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), hasQuery && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "s",
    title: _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.matchSuccess', {
      defaultMessage: 'Your index pattern matches {count, plural, one {# source} other {# sources}}.',
      values: {
        count: total
      }
    }),
    color: total === 0 ? 'warning' : 'success',
    iconType: total === 0 ? 'warning' : 'check',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems,
    columns: columns,
    loading: hasQuery ? isLoading : false,
    css: (0, _react2.css)`
          min-height: 300px; /* Prevent layout shift when loading */
        `,
    rowHeader: "name",
    noItemsMessage: hasQuery ? _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.noResultsTable', {
      defaultMessage: 'No results'
    }) : _i18n.i18n.translate('xpack.onechat.tools.indexPattern.pattern.typeToSearch', {
      defaultMessage: 'Start typing to see matching sources'
    }),
    pagination: {
      pageIndex,
      pageSize,
      totalItemCount: items.length,
      pageSizeOptions: [5, 10, 25, 50],
      showPerPageOptions: true
    },
    onChange: ({
      page
    }) => {
      if (page) {
        setPageIndex(page.index);
        setPageSize(page.size);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }));
};
exports.IndexSearchPattern = IndexSearchPattern;