"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutResultItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _thinking_item_layout = require("./thinking_item_layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/flyout_result_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  toolResponse: _i18n.i18n.translate('xpack.onechat.flyoutResultItem.toolResponseLabel', {
    defaultMessage: 'Tool response'
  }),
  inspectResponse: _i18n.i18n.translate('xpack.onechat.flyoutResultItem.inspectResponseLabel', {
    defaultMessage: 'Inspect tool response details'
  })
};
const FlyoutResultItem = ({
  step,
  stepIndex,
  flyoutResultItems,
  onOpenFlyout,
  icon
}) => {
  const responseId = `tool-response-${stepIndex}-${step.tool_id}`;
  const inspectButtonId = `inspect-response-${stepIndex}-${step.tool_id}`;
  return /*#__PURE__*/_react.default.createElement(_thinking_item_layout.ThinkingItemLayout, {
    icon: icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: responseId,
    role: "status",
    "aria-label": labels.toolResponse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.flyoutResultItem.toolCallThinkingItem",
    defaultMessage: "Tool {tool} returned response. {inspectResponse}",
    values: {
      tool: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        "aria-label": _i18n.i18n.translate('xpack.onechat.flyoutResultItem.toolName', {
          defaultMessage: 'Tool {toolId}',
          values: {
            toolId: step.tool_id
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }, step.tool_id),
      inspectResponse: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onOpenFlyout(flyoutResultItems),
        id: inspectButtonId,
        "aria-describedby": responseId,
        "aria-label": labels.inspectResponse,
        role: "button",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.onechat.flyoutResultItem.roundResultsButton', {
        defaultMessage: 'Inspect response'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }))));
};
exports.FlyoutResultItem = FlyoutResultItem;