"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundErrorThinkingTitle = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _conversation = require("../../conversation.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_error/round_error_thinking_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  reasoningError: _i18n.i18n.translate('xpack.onechat.round.error.reasoningError', {
    defaultMessage: 'Reasoning error'
  }),
  showThinkingPanel: _i18n.i18n.translate('xpack.onechat.round.error.showThinkingPanel', {
    defaultMessage: 'Show'
  })
};
const RoundErrorThinkingTitle = ({
  onClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const containerStyles = (0, _react.css)`
    background-color: ${euiTheme.colors.backgroundBaseDanger};
    ${_conversation.roundedBorderRadiusStyles}
    border: 1px solid ${euiTheme.colors.borderBaseDanger};
    padding: ${euiTheme.size.m};
    width: 100%;
  `;
  const textStyles = (0, _react.css)`
    color: ${euiTheme.colors.textDanger};
    font-weight: ${euiTheme.font.weight.medium};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    responsive: false,
    alignItems: "center",
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: euiTheme.colors.textDanger,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: textStyles,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, labels.reasoningError))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, labels.showThinkingPanel))));
};
exports.RoundErrorThinkingTitle = RoundErrorThinkingTitle;