"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundErrorThinkingPanel = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _conversation = require("../../conversation.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_error/round_error_thinking_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  reasoningError: _i18n.i18n.translate('xpack.onechat.round.error.reasoningError', {
    defaultMessage: 'Reasoning error'
  }),
  closeAriaLabel: _i18n.i18n.translate('xpack.onechat.round.error.closeAriaLabel', {
    defaultMessage: 'Close error panel'
  })
};
const fadeIn = (0, _react.keyframes)`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;
const RoundErrorThinkingPanel = ({
  children,
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const fadeInStyles = (0, _react.css)`
    animation: ${fadeIn} ${euiTheme.animation.normal} ease-in;
  `;
  const containerStyles = (0, _react.css)`
    ${fadeInStyles}
    background-color: ${euiTheme.colors.backgroundBasePlain};
    ${_conversation.roundedBorderRadiusStyles}
    border: 1px solid ${euiTheme.colors.borderStrongDanger};
    padding: ${euiTheme.size.base};
    ${(0, _eui.useEuiShadow)('l')};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: containerStyles,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    css: (0, _react.css)`
              color: ${euiTheme.colors.textDanger};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, labels.reasoningError))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": labels.closeAriaLabel,
    iconType: "cross",
    color: "text",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }))), children);
};
exports.RoundErrorThinkingPanel = RoundErrorThinkingPanel;