"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roundedBorderRadiusStyles = exports.fullWidthAndHeightStyles = exports.conversationElementWidthStyles = exports.conversationBackgroundStyles = exports.ROUNDED_BORDER_RADIUS_LARGE = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxConversationWidthStyles = (0, _react.css)`
  max-width: 800px;
`;

// Ensures the conversation element is always 100% of it's parent or 800px, whichever is smaller.
const conversationElementWidthStyles = exports.conversationElementWidthStyles = (0, _react.css)`
  width: 100%;
  ${maxConversationWidthStyles}
`;
const fullWidthAndHeightStyles = exports.fullWidthAndHeightStyles = (0, _react.css)`
  width: 100%;
  height: 100%;
`;
const ROUNDED_BORDER_RADIUS = '6px';
const ROUNDED_BORDER_RADIUS_LARGE = exports.ROUNDED_BORDER_RADIUS_LARGE = '12px';
const roundedBorderRadiusStyles = exports.roundedBorderRadiusStyles = (0, _react.css)`
  border-radius: ${ROUNDED_BORDER_RADIUS};
`;
const conversationBackgroundStyles = euiTheme => (0, _react.css)`
  background: linear-gradient(
    180deg,
    ${euiTheme.colors.backgroundBasePlain} 21.09%,
    ${euiTheme.colors.backgroundBaseSubdued} 51.44%,
    ${euiTheme.colors.backgroundBasePlain} 87.98%
  );
`;
exports.conversationBackgroundStyles = conversationBackgroundStyles;