"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewLocatorDefinition = exports.SERVICE_OVERVIEW_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE_OVERVIEW_LOCATOR_ID = exports.SERVICE_OVERVIEW_LOCATOR_ID = 'serviceOverviewLocator';
class ServiceOverviewLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", SERVICE_OVERVIEW_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      serviceName,
      environment
    }) => {
      const params = {
        rangeFrom,
        rangeTo,
        environment
      };
      return {
        app: 'apm',
        path: `/services/${encodeURIComponent(serviceName)}/overview?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.ServiceOverviewLocatorDefinition = ServiceOverviewLocatorDefinition;