"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimerange = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTimerange = (interval, timeframe, lastPeriodEnd, isRateAgg) => {
  const end = (0, _moment.default)(timeframe.end).valueOf();
  let start = (0, _moment.default)(timeframe.start).valueOf();
  const minimumBuckets = isRateAgg ? 2 : 1;
  interval = interval * minimumBuckets;
  start = end - interval;
  if (lastPeriodEnd && lastPeriodEnd - interval < start) {
    const maxAllowedLookBack = (0, _moment.default)(start).subtract(3 * interval, 'ms');
    // Calculate the maximum allowable look-back time (3 intervals before the current 'start' time).
    if ((0, _moment.default)(lastPeriodEnd).isAfter(maxAllowedLookBack)) {
      // Ensure lastPeriodEnd is within the allowable look-back range.
      start = lastPeriodEnd - interval;
    }
  }
  return {
    start,
    end
  };
};
exports.createTimerange = createTimerange;