"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedDashboards = RelatedDashboards;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _dashboard_tiles = require("./related_dashboards/dashboard_tiles");
var _use_add_suggested_dashboard = require("../hooks/use_add_suggested_dashboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/related_dashboards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RelatedDashboards({
  rule,
  isLoadingRelatedDashboards,
  linkedDashboards,
  suggestedDashboards,
  onSuccessAddSuggestedDashboard,
  timeRange
}) {
  const {
    onClickAddSuggestedDashboard,
    addingDashboardId
  } = (0, _use_add_suggested_dashboard.useAddSuggestedDashboards)({
    rule,
    onSuccessAddSuggestedDashboard
  });
  const suggestedDashboardsWithButton = (0, _react.useMemo)(() => suggestedDashboards === null || suggestedDashboards === void 0 ? void 0 : suggestedDashboards.map(d => {
    const ruleType = rule.ruleTypeId.split('.').pop();
    return {
      ...d,
      actionButtonProps: {
        isDisabled: addingDashboardId !== undefined && addingDashboardId !== d.id,
        isLoading: addingDashboardId === d.id,
        label: _i18n.i18n.translate('xpack.observability.alertDetails.suggestedDashboards.buttonLabel', {
          defaultMessage: 'Add to linked dashboards'
        }),
        onClick: onClickAddSuggestedDashboard,
        ruleType: ruleType || 'unknown'
      }
    };
  }), [addingDashboardId, onClickAddSuggestedDashboard, rule.ruleTypeId, suggestedDashboards]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_tiles.DashboardTiles, {
    title: _i18n.i18n.translate('xpack.observability.alertDetails.linkedDashboards', {
      defaultMessage: 'Linked dashboards'
    }),
    isLoadingDashboards: isLoadingRelatedDashboards,
    dashboards: linkedDashboards,
    dataTestSubj: "linked-dashboards",
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_dashboard_tiles.DashboardTiles, {
    title: _i18n.i18n.translate('xpack.observability.alertDetails.suggestedDashboards', {
      defaultMessage: 'Suggested dashboards'
    }),
    isLoadingDashboards: isLoadingRelatedDashboards,
    dashboards: suggestedDashboardsWithButton,
    dataTestSubj: "suggested-dashboards",
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
}