"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _timestamp_range_label = require("../timestamp_range_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/annotation_tooltip/annotation_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AnnotationTooltip({
  annotation
}) {
  var _annotation$annotatio, _annotation$message, _annotation$slo;
  const listItems = [{
    title: _i18n.i18n.translate('xpack.observability.annotationTooltip.title', {
      defaultMessage: 'Title'
    }),
    description: (_annotation$annotatio = annotation.annotation.title) !== null && _annotation$annotatio !== void 0 ? _annotation$annotatio : '--'
  }, {
    title: _i18n.i18n.translate('xpack.observability.annotationTooltip.tags', {
      defaultMessage: 'Tags'
    }),
    description: /*#__PURE__*/_react.default.createElement(_public.TagsList, {
      tags: annotation.tags,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 20
      }
    })
  }, {
    title: _i18n.i18n.translate('xpack.observability.annotationTooltip.description', {
      defaultMessage: 'Description'
    }),
    description: (_annotation$message = annotation.message) !== null && _annotation$message !== void 0 ? _annotation$message : '--'
  }];
  if ((_annotation$slo = annotation.slo) !== null && _annotation$slo !== void 0 && _annotation$slo.id) {
    var _annotation$slo2;
    listItems.push({
      title: _i18n.i18n.translate('xpack.observability.annotationTooltip.slo', {
        defaultMessage: 'SLO'
      }),
      description: (_annotation$slo2 = annotation.slo) === null || _annotation$slo2 === void 0 ? void 0 : _annotation$slo2.id
    });
  }
  if (annotation.service) {
    var _annotation$service$n;
    listItems.push({
      title: _i18n.i18n.translate('xpack.observability.annotationTooltip.service', {
        defaultMessage: 'Service'
      }),
      description: (_annotation$service$n = annotation.service.name) !== null && _annotation$service$n !== void 0 ? _annotation$service$n : '--'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasShadow: false,
    hasBorder: false,
    paddingSize: "m",
    borderRadius: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_.AnnotationIcon, {
    annotation: annotation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_timestamp_range_label.TimestampRangeLabel, {
    annotation: annotation,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: listItems,
    type: "column",
    columnWidths: [1, 3] // Same as [25, 75]
    ,
    style: {
      maxInlineSize: '400px'
    },
    descriptionProps: {
      'data-test-subj': 'annotation-tooltip-description'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AnnotationTooltip;
module.exports = exports.default;