"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Insight = Insight;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _types = require("../../../common/types");
var _observability_ai_assistant_chat_service_context = require("../../context/observability_ai_assistant_chat_service_context");
var _use_abortable_async = require("../../hooks/use_abortable_async");
var _use_chat = require("../../hooks/use_chat");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_observability_ai_assistant = require("../../hooks/use_observability_ai_assistant");
var _use_observability_ai_assistant_chat_service = require("../../hooks/use_observability_ai_assistant_chat_service");
var _use_flyout_state = require("../../hooks/use_flyout_state");
var _navigate_to_connectors = require("../../utils/navigate_to_connectors");
var _regenerate_response_button = require("../buttons/regenerate_response_button");
var _start_chat_button = require("../buttons/start_chat_button");
var _stop_generating_button = require("../buttons/stop_generating_button");
var _feedback_buttons = require("../buttons/feedback_buttons");
var _message_panel = require("../message_panel/message_panel");
var _message_text = require("../message_panel/message_text");
var _missing_credentials_callout = require("../missing_credentials_callout");
var _insight_base = require("./insight_base");
var _actions_menu = require("./actions_menu");
var _telemetry_event_type = require("../../analytics/telemetry_event_type");
var _get_elastic_managed_llm_connector = require("../../utils/get_elastic_managed_llm_connector");
var _elastic_llm_tour_callout = require("../tour_callout/elastic_llm_tour_callout");
var _use_elastic_llm_callout_dismissed = require("../../hooks/use_elastic_llm_callout_dismissed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/insight/insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getLastMessageOfType(messages, role) {
  return (0, _lodash.last)(messages.filter(msg => msg.message.role === role));
}
function ChatContent({
  title: defaultTitle,
  initialMessages,
  connectorId,
  setIsTourCalloutOpen
}) {
  var _lastAssistantRespons;
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const chatService = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const scopes = chatService.getScopes();
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const initialMessagesRef = (0, _react.useRef)(initialMessages);
  const {
    flyoutState
  } = (0, _use_flyout_state.useFlyoutState)();
  const {
    messages,
    next,
    state,
    stop
  } = (0, _use_chat.useChat)({
    service,
    chatService,
    connectorId,
    initialMessages,
    persist: false,
    disableFunctions: true,
    scopes
  });
  const lastAssistantResponse = getLastMessageOfType(messages.slice(initialMessagesRef.current.length + 1), _types.MessageRole.Assistant);
  (0, _react.useEffect)(() => {
    next(initialMessagesRef.current);
  }, [next]);
  (0, _react.useEffect)(() => {
    if (state !== _use_chat.ChatState.Loading && lastAssistantResponse) {
      const connector = connectors.getConnector(connectors.selectedConnector || '');
      chatService.sendAnalyticsEvent({
        type: _telemetry_event_type.ObservabilityAIAssistantTelemetryEventType.InsightResponse,
        payload: {
          '@timestamp': lastAssistantResponse['@timestamp'],
          connector,
          scopes
        }
      });
    }
  }, [state, lastAssistantResponse, chatService, connectors, scopes]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_message_panel.MessagePanel, {
    body: /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
      content: (_lastAssistantRespons = lastAssistantResponse === null || lastAssistantResponse === void 0 ? void 0 : lastAssistantResponse.message.content) !== null && _lastAssistantRespons !== void 0 ? _lastAssistantRespons : '',
      loading: state === _use_chat.ChatState.Loading,
      onActionClick: async () => {},
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }),
    error: state === _use_chat.ChatState.Error,
    controls: state === _use_chat.ChatState.Loading ? /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
      onClick: () => {
        stop();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
      onClickFeedback: feedback => {
        if (lastAssistantResponse) {
          const connector = connectors.getConnector(connectors.selectedConnector || '');
          chatService.sendAnalyticsEvent({
            type: _telemetry_event_type.ObservabilityAIAssistantTelemetryEventType.InsightFeedback,
            payload: {
              feedback,
              connector,
              scopes
            }
          });
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: () => {
        next(initialMessages);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_start_chat_button.StartChatButton, {
      disabled: flyoutState.isOpen,
      onClick: () => {
        setIsTourCalloutOpen(false);
        service.conversations.openNewConversation({
          messages,
          title: defaultTitle,
          hideConversationList: true
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 17
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
}
function PromptEdit({
  initialPrompt,
  onSend,
  onCancel
}) {
  const [prompt, setPrompt] = (0, _react.useState)(initialPrompt);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "observabilityAiAssistantInsightEditPromptTextArea",
    inputRef: textarea => {
      if (textarea) {
        setTimeout(() => textarea.focus());
      }
    },
    fullWidth: true,
    defaultValue: prompt,
    onChange: ev => {
      setPrompt(ev.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.cancelPromptEdit', {
      defaultMessage: 'Cancel'
    }),
    "data-test-subj": "observabilityAiAssistantInsightCancelEditPromptButtonIcon",
    iconType: "cross",
    display: "base",
    color: "danger",
    size: "m",
    onClick: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.sendPromptEdit', {
      defaultMessage: 'Send prompt'
    }),
    "data-test-subj": "observabilityAiAssistantInsightSendEditPromptButtonIcon",
    iconType: "kqlFunction",
    display: "fill",
    size: "m",
    onClick: () => onSend(prompt),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  })));
}
var FETCH_STATUS = /*#__PURE__*/function (FETCH_STATUS) {
  FETCH_STATUS["LOADING"] = "loading";
  FETCH_STATUS["SUCCESS"] = "success";
  FETCH_STATUS["FAILURE"] = "failure";
  FETCH_STATUS["NOT_INITIATED"] = "not_initiated";
  return FETCH_STATUS;
}(FETCH_STATUS || {});
function Insight({
  messages: initialMessagesOrCallback,
  title,
  dataTestSubj,
  showElasticLlmCallout = true
}) {
  var _connectors$connector;
  const [messages, setMessages] = (0, _react.useState)({
    messages: [],
    status: FETCH_STATUS.NOT_INITIATED
  });
  const [isEditingPrompt, setEditingPrompt] = (0, _react.useState)(false);
  const [isInsightOpen, setInsightOpen] = (0, _react.useState)(false);
  const [hasOpened, setHasOpened] = (0, _react.useState)(false);
  const [isPromptUpdated, setIsPromptUpdated] = (0, _react.useState)(false);
  const [isTourCalloutOpen, setIsTourCalloutOpen] = (0, _react.useState)(true);
  const [tourCalloutDismissed, setTourCalloutDismissed] = (0, _use_elastic_llm_callout_dismissed.useElasticLlmCalloutDismissed)(_use_elastic_llm_callout_dismissed.ElasticLlmCalloutKey.TOUR_CALLOUT, false);
  const updateInitialMessages = (0, _react.useCallback)(async () => {
    if ((0, _lodash.isArray)(initialMessagesOrCallback)) {
      setMessages({
        messages: initialMessagesOrCallback,
        status: FETCH_STATUS.SUCCESS
      });
      return;
    }
    setMessages({
      messages: [],
      status: FETCH_STATUS.LOADING
    });
    try {
      const data = await initialMessagesOrCallback();
      setMessages({
        messages: data !== null && data !== void 0 ? data : [],
        status: FETCH_STATUS.SUCCESS
      });
    } catch (e) {
      setMessages({
        messages: [],
        status: FETCH_STATUS.FAILURE
      });

      // eslint-disable-next-line no-console
      console.log('could not load insight messages', e);
    }
  }, [initialMessagesOrCallback]);
  const updateInitialMessagesOnce = (0, _react.useMemo)(() => (0, _lodash.once)(updateInitialMessages), [updateInitialMessages]);
  (0, _react.useEffect)(() => {
    if (isInsightOpen) {
      updateInitialMessagesOnce();
    }
  }, [updateInitialMessagesOnce, isInsightOpen]);
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const chatService = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return service.start({
      signal
    });
  }, [service]);
  const getPromptToEdit = () => {
    var _getLastMessageOfType;
    const clonedMessages = (0, _lodash.cloneDeep)(messages.messages);
    const lastUserPrompt = (_getLastMessageOfType = getLastMessageOfType(clonedMessages, _types.MessageRole.User)) === null || _getLastMessageOfType === void 0 ? void 0 : _getLastMessageOfType.message.content;
    if (!lastUserPrompt) {
      return '';
    }
    try {
      const {
        instructions = ''
      } = JSON.parse(lastUserPrompt);
      return instructions.trim();
    } catch (e) {
      return '';
    }
  };
  const onEditPrompt = newPrompt => {
    const clonedMessages = (0, _lodash.cloneDeep)(messages.messages);
    const userMessage = getLastMessageOfType(clonedMessages, _types.MessageRole.User);
    if (!userMessage) return false;
    try {
      const parsedContent = JSON.parse(userMessage.message.content || '');
      if (!parsedContent.instructions) {
        return false;
      }

      // Assign the updated instructions
      parsedContent.instructions = newPrompt;
      userMessage.message.content = JSON.stringify(parsedContent);
      setIsPromptUpdated(true);
      setMessages({
        messages: clonedMessages,
        status: FETCH_STATUS.SUCCESS
      });
      setEditingPrompt(false);
      return true;
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error('Failed to edit prompt:', e);
      return false;
    }
  };
  const handleCancel = () => {
    setEditingPrompt(false);
    setInsightOpen(false);
    setHasOpened(false);
  };
  const {
    services: {
      http,
      plugins: {
        start: {
          licensing
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const license = (0, _useObservable.default)(licensing.license$);
  const hasEnterpriseLicense = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');
  if ((0, _lodash.isEmpty)(connectors.connectors) || !hasEnterpriseLicense) {
    return null;
  }
  let children = null;
  if (connectors.selectedConnector && (!isInsightOpen && hasOpened || isInsightOpen && !isEditingPrompt && messages.status === FETCH_STATUS.SUCCESS)) {
    children = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPromptUpdated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.insightModifiedPrompt', {
      defaultMessage: 'This insight has been modified.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilityAiAssistantInsightResetDefaultPrompt",
      onClick: () => {
        setIsPromptUpdated(false);
        setHasOpened(false);
        setInsightOpen(false);
        updateInitialMessages();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 398,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.resetDefaultPrompt', {
      defaultMessage: 'Reset to default'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 417,
        columnNumber: 13
      }
    })) : null, /*#__PURE__*/_react.default.createElement(ChatContent, {
      title: title,
      initialMessages: messages.messages,
      connectorId: connectors.selectedConnector,
      setIsTourCalloutOpen: setIsTourCalloutOpen,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 421,
        columnNumber: 9
      }
    }));
  } else if (isEditingPrompt) {
    const promptToEdit = getPromptToEdit();
    if (messages.status === FETCH_STATUS.SUCCESS && promptToEdit) {
      children = /*#__PURE__*/_react.default.createElement(PromptEdit, {
        initialPrompt: promptToEdit,
        onSend: onEditPrompt,
        onCancel: handleCancel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 434,
          columnNumber: 9
        }
      });
    } else {
      children = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 437,
          columnNumber: 18
        }
      });
    }
  } else if (!connectors.loading && !((_connectors$connector = connectors.connectors) !== null && _connectors$connector !== void 0 && _connectors$connector.length)) {
    children = /*#__PURE__*/_react.default.createElement(_missing_credentials_callout.MissingCredentialsCallout, {
      connectorsManagementHref: (0, _navigate_to_connectors.getConnectorsManagementHref)(http),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 441,
        columnNumber: 7
      }
    });
  } else if (messages.status === FETCH_STATUS.FAILURE) {
    children = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      size: "s",
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.div.errorFetchingMessagesLabel', {
        defaultMessage: 'Could not fetch prompt messages'
      }),
      color: "danger",
      iconType: "error",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 445,
        columnNumber: 7
      }
    });
  }
  const elasticManagedLlm = (0, _get_elastic_managed_llm_connector.getElasticManagedLlmConnector)(connectors.connectors);
  return /*#__PURE__*/_react.default.createElement(_insight_base.InsightBase, {
    title: title,
    onToggle: isOpen => {
      setHasOpened(prevHasOpened => {
        if (isEditingPrompt) return false;
        return prevHasOpened || isOpen;
      });
      setInsightOpen(isOpen);
    },
    controls: !!elasticManagedLlm && showElasticLlmCallout ? /*#__PURE__*/_react.default.createElement(_elastic_llm_tour_callout.ElasticLlmTourCallout, {
      isOpen: !tourCalloutDismissed && isTourCalloutOpen,
      zIndex: 999,
      dismissTour: () => setTourCalloutDismissed(true),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_actions_menu.ActionsMenu, {
      connectors: connectors,
      onEditPrompt: () => {
        setEditingPrompt(true);
        setInsightOpen(true);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 479,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement(_actions_menu.ActionsMenu, {
      connectors: connectors,
      onEditPrompt: () => {
        setEditingPrompt(true);
        setInsightOpen(true);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 488,
        columnNumber: 11
      }
    }),
    loading: connectors.loading || chatService.loading,
    dataTestSubj: dataTestSubj,
    isOpen: isInsightOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 5
    }
  }, chatService.value ? /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_chat_service_context.ObservabilityAIAssistantChatServiceContext.Provider, {
    value: chatService.value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 502,
      columnNumber: 9
    }
  }, children) : null);
}