"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAiInsightAttachmentType = exports.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID = void 0;
var _zod = require("@kbn/zod");
var _dedent = _interopRequireDefault(require("dedent"));
var _constants = require("../../common/constants");
var _get_alerts = require("../tools/get_alerts/get_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID = exports.OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID = 'observability.ai_insight';
const aiInsightAttachmentDataSchema = _zod.z.object({
  context: _zod.z.string(),
  summary: _zod.z.string()
});
/**
 * Type guard to ensure `attachment.data` conforms to AiInsightAttachmentData.
 */
const isValidAiInsightAttachmentData = data => {
  return aiInsightAttachmentDataSchema.safeParse(data).success;
};
const createAiInsightAttachmentType = () => {
  return {
    id: OBSERVABILITY_AI_INSIGHT_ATTACHMENT_TYPE_ID,
    validate: input => {
      const parsed = aiInsightAttachmentDataSchema.safeParse(input);
      if (!parsed.success) {
        return {
          valid: false,
          error: parsed.error.message
        };
      }
      return {
        valid: true,
        data: parsed.data
      };
    },
    format: attachment => {
      return {
        getRepresentation: () => {
          // Agent Builder does not apply the attachment schema at `format` time
          // so we re-validate it before using it.
          if (!isValidAiInsightAttachmentData(attachment.data)) {
            throw new Error(`Invalid AI insight attachment data for attachment ${attachment.id}`);
          }
          const {
            summary,
            context
          } = attachment.data;
          const value = [`AI summary:\n${summary}`, `Context data:\n${context}`].join('\n\n');
          return {
            type: 'text',
            value
          };
        }
      };
    },
    getAgentDescription: () => {
      return (0, _dedent.default)(`
        The AI Insight attachment carries a concise natural-language summary (aiSummary) and contextual data (contextData) relevant to observability investigations.
      `);
    },
    getTools: () => [_constants.OBSERVABILITY_GET_SERVICES_TOOL_ID, _get_alerts.OBSERVABILITY_GET_ALERTS_TOOL_ID, _constants.OBSERVABILITY_GET_DOWNSTREAM_DEPENDENCIES_TOOL_ID]
  };
};
exports.createAiInsightAttachmentType = createAiInsightAttachmentType;