"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Statement = Statement;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _plugin_statement = require("../models/pipeline/plugin_statement");
var _collapsible_statement = require("./collapsible_statement");
var _if_element = require("../models/list/if_element");
var _plugin_statement2 = require("./plugin_statement");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_viewer/views/statement.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const spaceContainerStyle = ({
  euiTheme
}) => (0, _react2.css)`
  background-color: ${euiTheme.colors.backgroundBasePlain};
  align-self: stretch;
  display: flex;
  // Separates the left border spaces properly
  ${(0, _eui.logicalCSS)('border-bottom', `solid 2px ${euiTheme.colors.emptyShade}`)}
`;
const spacerStyle = ({
  euiTheme
}) => (0, _react2.css)`
  width: ${euiTheme.size.m};
  align-self: stretch;
  ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.m)}
  ${(0, _eui.logicalCSS)('border-left', `1px ${euiTheme.border.color} dashed`)}

  // This allows the border to be flush
  &:last-child {
    width: 0;
  }

  &:first-child {
    // Odd number is because of the single pixel border
    ${(0, _eui.logicalCSS)('margin-left', `calc(${euiTheme.size.l}) - 1px)`)}
  }

  @media (min-width: var(${euiTheme.breakpoint.m})) {
    border: none;
  }
`;
const listItemStyle = ({
  euiTheme
}) => (0, _react2.css)`
  display: flex;
  min-height: ${euiTheme.size.xl};
  align-items: center;
  ${(0, _eui.logicalCSS)('padding-right', euiTheme.size.m)}

  &:nth-child(2n + 1) {
    background: ${euiTheme.colors.lightestShade};
  }
`;
const conditionalStyle = ({
  euiTheme
}) => (0, _react2.css)`
  font-weight: ${euiTheme.font.weight.bold};
`;
function renderStatementName(name, onVertexSelected) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: "statementName",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": name,
    color: "text",
    size: "xs",
    onClick: onVertexSelected,
    flush: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: conditionalStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, name)));
}
function renderIfStatement({
  condition
}, onVertexSelected) {
  return [renderStatementName('if', onVertexSelected), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "ifContent",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "s",
    paddingSize: "none",
    transparentBackground: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, condition))];
}
function getStatementBody(isIf, statement, vertex, onShowVertexDetails) {
  const showVertexDetailsClicked = () => {
    onShowVertexDetails(vertex);
  };
  return isIf ? renderIfStatement(statement, showVertexDetailsClicked) : renderStatementName('else', showVertexDetailsClicked);
}
function renderNestingSpacers(depth) {
  const spacers = [];
  for (let i = 0; i < depth; i += 1) {
    spacers.push(/*#__PURE__*/_react.default.createElement("div", {
      key: `spacer_${i}`,
      css: spacerStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 18
      }
    }));
  }
  return spacers;
}
function renderStatement({
  collapse,
  element,
  element: {
    id,
    statement,
    statement: {
      vertex
    }
  },
  expand,
  isCollapsed,
  onShowVertexDetails
}) {
  if (statement instanceof _plugin_statement.PluginStatement) {
    return /*#__PURE__*/_react.default.createElement(_plugin_statement2.PluginStatement, {
      statement: statement,
      onShowVertexDetails: onShowVertexDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 12
      }
    });
  }
  const statementBody = getStatementBody(element instanceof _if_element.IfElement, statement, vertex, onShowVertexDetails);
  return /*#__PURE__*/_react.default.createElement(_collapsible_statement.CollapsibleStatement, {
    expand: expand,
    collapse: collapse,
    isCollapsed: isCollapsed,
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 5
    }
  }, statementBody);
}
function Statement(props) {
  const {
    depth
  } = props.element;
  return /*#__PURE__*/_react.default.createElement("li", {
    className: `monPipelineViewer__listItem`,
    css: listItemStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: spaceContainerStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, renderNestingSpacers(depth)), renderStatement(props));
}