"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartTarget = void 0;
var _lodash = require("lodash");
var _jquery = _interopRequireDefault(require("jquery"));
var _react = _interopRequireDefault(require("react"));
var _event_bus = require("./event_bus");
var _get_chart_options = require("./get_chart_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/chart_target.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ChartTarget extends _react.default.Component {
  shouldComponentUpdate() {
    return !this.plot;
  }
  shutdownChart() {
    if (!this.plot) {
      return;
    }
    const {
      target
    } = this.refs;
    (0, _jquery.default)(target).off('plothover');
    (0, _jquery.default)(target).off('mouseleave');
    (0, _jquery.default)(target).off('plotselected');
    (0, _jquery.default)(target).off('plotselecting');
    this.plot.shutdown();
    _event_bus.eventBus.off('thorPlotHover');
    _event_bus.eventBus.off('thorPlotLeave');
    _event_bus.eventBus.off('thorPlotSelecting');
    _event_bus.eventBus.off('thorPlotBrush');
  }
  componentWillUnmount() {
    this.shutdownChart();
    window.removeEventListener('resize', this._handleResize);
    this.componentUnmounted = true;
  }
  filterByShow(seriesToShow) {
    if (seriesToShow) {
      return metric => {
        return seriesToShow.some(id => id.toLowerCase() === metric.id.toLowerCase());
      };
    }
    return () => true;
  }
  UNSAFE_componentWillReceiveProps(newProps) {
    if (this.plot && !(0, _lodash.isEqual)(newProps, this.props)) {
      const {
        series,
        timeRange
      } = newProps;
      const xaxisOptions = this.plot.getAxes().xaxis.options;
      xaxisOptions.min = (0, _lodash.get)(timeRange, 'min');
      xaxisOptions.max = (0, _lodash.get)(timeRange, 'max');
      this.plot.setData(this.filterData(series, newProps.seriesToShow));
      this.plot.setupGrid();
      this.plot.draw();
    }
  }
  componentDidMount() {
    this.renderChart();
  }
  componentDidUpdate() {
    this.shutdownChart();
    this.renderChart();
  }
  filterData(data, seriesToShow) {
    return (0, _lodash.filter)(data, this.filterByShow(seriesToShow));
  }
  async getOptions() {
    const opts = await (0, _get_chart_options.getChartOptions)({
      yaxis: {
        tickFormatter: this.props.tickFormatter
      },
      xaxis: this.props.timeRange
    });
    return {
      ...opts,
      ...this.props.options
    };
  }
  async renderChart() {
    const {
      target
    } = this.refs;
    const {
      series
    } = this.props;
    const data = this.filterData(series, this.props.seriesToShow);
    this.plot = _jquery.default.plot(target, data, await this.getOptions());
    if (this.componentUnmounted || !this.plot) {
      return;
    }
    this._handleResize = () => {
      if (!this.plot) {
        return;
      }
      try {
        this.plot.resize();
        this.plot.setupGrid();
        this.plot.draw();
      } catch (e) {
        // eslint-disable-line no-empty
        /* It is ok to silently swallow the error here. Resize events fire
         * continuously so the proper resize will happen in a later firing of
         * the event */
      }
    };
    window.addEventListener('resize', this._handleResize, false);
    this.handleMouseLeave = () => {
      _event_bus.eventBus.trigger('thorPlotLeave', []);
    };
    this.handlePlotHover = (_event, pos, item) => {
      _event_bus.eventBus.trigger('thorPlotHover', [pos, item, this.plot]);
    };
    this.handleThorPlotHover = (_event, pos, item, originalPlot) => {
      if (this.plot !== originalPlot) {
        // the crosshair is set for the original chart already
        this.plot.setCrosshair({
          x: (0, _lodash.get)(pos, 'x')
        });
      }
      this.props.updateLegend(pos, item);
    };
    this.handleThorPlotLeave = () => {
      this.plot.clearCrosshair();
      this.props.updateLegend(); // gets last values
    };
    this.handleThorPlotSelecting = (_event, xaxis, originalPlot) => {
      if (this.plot !== originalPlot) {
        const preventEvent = true;
        this.plot.setSelection({
          xaxis
        }, preventEvent);
      }
    };
    this.handleThorPlotBrush = () => {
      this.plot.clearSelection();
    };
    this.selectingChart = (_event, ranges) => {
      if (ranges) {
        const xaxis = ranges.xaxis;
        _event_bus.eventBus.trigger('thorPlotSelecting', [xaxis, this.plot]);
      }
    };
    this.brushChart = (_event, ranges) => {
      this.props.onBrush(ranges);
      _event_bus.eventBus.trigger('thorPlotBrush');
    };
    (0, _jquery.default)(target).on('plothover', this.handlePlotHover);
    (0, _jquery.default)(target).on('mouseleave', this.handleMouseLeave);
    (0, _jquery.default)(target).on('plotselected', this.brushChart);
    (0, _jquery.default)(target).on('plotselecting', this.selectingChart);
    _event_bus.eventBus.on('thorPlotHover', this.handleThorPlotHover);
    _event_bus.eventBus.on('thorPlotLeave', this.handleThorPlotLeave);
    _event_bus.eventBus.on('thorPlotSelecting', this.handleThorPlotSelecting);
    _event_bus.eventBus.on('thorPlotBrush', this.handleThorPlotBrush);
  }
  render() {
    const style = {
      position: 'relative',
      display: 'flex',
      rowDirection: 'column',
      flex: '1 0 auto'
    };
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: "target",
      style: style,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 12
      }
    });
  }
}
exports.ChartTarget = ChartTarget;