"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQL_AUTOCOMPLETE_TRIGGER_CHARS = exports.ESQLLang = void 0;
var _function_names = require("@kbn/esql-ast/src/definitions/generated/function_names");
var _monacoEsql = require("@elastic/monaco-esql");
var monarchDefinitions = _interopRequireWildcard(require("@elastic/monaco-esql/lib/definitions"));
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _monaco_imports = require("../../monaco_imports");
var _constants = require("./lib/constants");
var _positions = require("./lib/converters/positions");
var _suggestions = require("./lib/converters/suggestions");
var _utils = require("./lib/shared/utils");
var _theme = require("./lib/theme");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const removeKeywordSuffix = name => {
  return name.endsWith('.keyword') ? name.slice(0, -8) : name;
};
const ESQL_AUTOCOMPLETE_TRIGGER_CHARS = exports.ESQL_AUTOCOMPLETE_TRIGGER_CHARS = ['(', ' ', '[', '?'];
const ESQLLang = exports.ESQLLang = {
  ID: _constants.ESQL_LANG_ID,
  async onLanguage() {
    const language = _monacoEsql.monarch.create({
      ...monarchDefinitions,
      functions: _function_names.esqlFunctionNames
    });
    _monaco_imports.monaco.languages.setMonarchTokensProvider(_constants.ESQL_LANG_ID, language);
  },
  languageThemeResolver: _theme.buildEsqlTheme,
  languageConfiguration: {
    brackets: [['(', ')'], ['[', ']']],
    autoClosingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: '[',
      close: ']'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"""',
      close: '"""'
    }, {
      open: '"',
      close: '"'
    }],
    surroundingPairs: [{
      open: '(',
      close: ')'
    }, {
      open: `'`,
      close: `'`
    }, {
      open: '"""',
      close: '"""'
    }, {
      open: '"',
      close: '"'
    }]
  },
  validate: async (model, code, callbacks, options) => {
    const text = code !== null && code !== void 0 ? code : model.getValue();
    const {
      errors,
      warnings
    } = await (0, _esqlValidationAutocomplete.validateQuery)(text, callbacks, options);
    const monacoErrors = (0, _positions.wrapAsMonacoMessages)(text, errors);
    const monacoWarnings = (0, _positions.wrapAsMonacoMessages)(text, warnings);
    return {
      errors: monacoErrors,
      warnings: monacoWarnings
    };
  },
  getHoverProvider: deps => {
    let lastHoveredWord;
    return {
      async provideHover(model, position, token) {
        var _deps$telemetry;
        const fullText = model.getValue();
        const offset = (0, _utils.monacoPositionToOffset)(fullText, position);
        const hoveredWord = model.getWordAtPosition(position);

        // Monaco triggers the hover event on each char of the word,
        // we only want to track the Hover if the word changed.
        if (hoveredWord && hoveredWord.word !== lastHoveredWord && deps !== null && deps !== void 0 && (_deps$telemetry = deps.telemetry) !== null && _deps$telemetry !== void 0 && _deps$telemetry.onDecorationHoverShown) {
          lastHoveredWord = hoveredWord.word;
          const hoverMessages = (0, _utils.getDecorationHoveredMessages)(hoveredWord, position, model);
          if (hoverMessages.length) {
            var _deps$telemetry2;
            deps === null || deps === void 0 ? void 0 : (_deps$telemetry2 = deps.telemetry) === null || _deps$telemetry2 === void 0 ? void 0 : _deps$telemetry2.onDecorationHoverShown(hoverMessages.join(', '));
          }
        }
        return (0, _esqlValidationAutocomplete.getHoverItem)(fullText, offset, deps);
      }
    };
  },
  getInlineCompletionsProvider: callbacks => {
    const provider = {
      async provideInlineCompletions(model, position) {
        const fullText = model.getValue();
        // Get the text before the cursor
        const textBeforeCursor = model.getValueInRange({
          startLineNumber: 1,
          startColumn: 1,
          endLineNumber: position.lineNumber,
          endColumn: position.column
        });
        const range = new _monaco_imports.monaco.Range(position.lineNumber, position.column, position.lineNumber, position.column);
        return await (0, _esqlValidationAutocomplete.inlineSuggest)(fullText, textBeforeCursor, range, callbacks);
      },
      freeInlineCompletions: () => {}
    };
    return provider;
  },
  getSuggestionProvider: deps => {
    return {
      triggerCharacters: ESQL_AUTOCOMPLETE_TRIGGER_CHARS,
      async provideCompletionItems(model, position) {
        const fullText = model.getValue();
        const offset = (0, _utils.monacoPositionToOffset)(fullText, position);
        const suggestions = await (0, _esqlValidationAutocomplete.suggest)(fullText, offset, deps);
        const suggestionsWithCustomCommands = (0, _utils.filterSuggestionsWithCustomCommands)(suggestions);
        if (suggestionsWithCustomCommands.length) {
          var _deps$telemetry3, _deps$telemetry3$onSu;
          deps === null || deps === void 0 ? void 0 : (_deps$telemetry3 = deps.telemetry) === null || _deps$telemetry3 === void 0 ? void 0 : (_deps$telemetry3$onSu = _deps$telemetry3.onSuggestionsWithCustomCommandShown) === null || _deps$telemetry3$onSu === void 0 ? void 0 : _deps$telemetry3$onSu.call(_deps$telemetry3, suggestionsWithCustomCommands);
        }
        return (0, _suggestions.wrapAsMonacoSuggestions)(suggestions, fullText);
      },
      async resolveCompletionItem(item, token) {
        if (!(deps !== null && deps !== void 0 && deps.getFieldsMetadata)) return item;
        const fieldsMetadataClient = await (deps === null || deps === void 0 ? void 0 : deps.getFieldsMetadata);
        const fullEcsMetadataList = await (fieldsMetadataClient === null || fieldsMetadataClient === void 0 ? void 0 : fieldsMetadataClient.find({
          attributes: ['type']
        }));
        if (!fullEcsMetadataList || !fieldsMetadataClient || typeof item.label !== 'string') return item;
        const strippedFieldName = removeKeywordSuffix(item.label);
        if (
        // If item is not a field, no need to fetch metadata
        item.kind === _monaco_imports.monaco.languages.CompletionItemKind.Variable &&
        // If not ECS, no need to fetch description
        Object.hasOwn(fullEcsMetadataList === null || fullEcsMetadataList === void 0 ? void 0 : fullEcsMetadataList.fields, strippedFieldName)) {
          const ecsMetadata = await fieldsMetadataClient.find({
            fieldNames: [strippedFieldName],
            attributes: ['description']
          });
          const fieldMetadata = ecsMetadata.fields[strippedFieldName];
          if (fieldMetadata && fieldMetadata.description) {
            const completionItem = {
              ...item,
              documentation: {
                value: fieldMetadata.description
              }
            };
            return completionItem;
          }
        }
        return item;
      }
    };
  }
};