"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severityThresholdSchema = exports.anomalyChartsEmbeddableStateSchema = exports.anomalyChartsEmbeddableRuntimeStateSchema = exports.anomalyChartsEmbeddableOverridableStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _schemas = require("@kbn/ml-anomaly-utils/schemas");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severityThresholdSchema = exports.severityThresholdSchema = _configSchema.schema.object({
  min: _configSchema.schema.number(),
  max: _configSchema.schema.maybe(_configSchema.schema.number())
});
const anomalyChartsEmbeddableRuntimeStateSchema = exports.anomalyChartsEmbeddableRuntimeStateSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  maxSeriesToPlot: _configSchema.schema.number(),
  severityThreshold: _configSchema.schema.maybe(_configSchema.schema.arrayOf(severityThresholdSchema)),
  selectedEntities: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_schemas.mlEntityFieldSchema))
});
const anomalyChartsEmbeddableOverridableStateSchema = exports.anomalyChartsEmbeddableOverridableStateSchema = _configSchema.schema.object({
  ...anomalyChartsEmbeddableRuntimeStateSchema.getPropSchemas(),
  timeRange: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema)
});
const anomalyChartsEmbeddableStateSchema = exports.anomalyChartsEmbeddableStateSchema = _configSchema.schema.object({
  ..._presentationPublishingSchemas.serializedTitlesSchema.getPropSchemas(),
  ...anomalyChartsEmbeddableOverridableStateSchema.getPropSchemas()
});