"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _common = require("@kbn/field-formats-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/cases/single_metric_viewer_attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const initComponent = exports.initComponent = (0, _lodash.memoize)((fieldFormats, SingleMetricViewerComponent) => {
  return /*#__PURE__*/_react.default.memo(props => {
    var _inputProps$query, _inputProps$query2;
    const {
      persistableStateAttachmentState,
      caseData
    } = props;
    const inputProps = persistableStateAttachmentState;
    const dataFormatter = fieldFormats.deserialize({
      id: _common.FIELD_FORMAT_IDS.DATE
    });
    const listItems = [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.singleMetricViewer.description.jobIdLabel",
        defaultMessage: "Job ID",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 15
        }
      }),
      description: inputProps.jobIds.join(', ')
    }, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.singleMetricViewer.description.timeRangeLabel",
        defaultMessage: "Time range",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }),
      description: `${dataFormatter.convert(inputProps.timeRange.from)} - ${dataFormatter.convert(inputProps.timeRange.to)}`
    }];
    if (typeof ((_inputProps$query = inputProps.query) === null || _inputProps$query === void 0 ? void 0 : _inputProps$query.query) === 'string' && ((_inputProps$query2 = inputProps.query) === null || _inputProps$query2 === void 0 ? void 0 : _inputProps$query2.query) !== '') {
      var _inputProps$query3;
      listItems.push({
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.cases.singleMetricViewer.description.queryLabel",
          defaultMessage: "Query",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 15
          }
        }),
        description: (_inputProps$query3 = inputProps.query) === null || _inputProps$query3 === void 0 ? void 0 : _inputProps$query3.query
      });
    }
    const {
      jobIds,
      timeRange,
      ...rest
    } = inputProps;
    const selectedJobId = jobIds[0];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: 'inline',
      listItems: listItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(SingleMetricViewerComponent, (0, _extends2.default)({
      bounds: {
        min: (0, _moment.default)(timeRange.from),
        max: (0, _moment.default)(timeRange.to)
      },
      lastRefresh: Date.now(),
      selectedJobId: selectedJobId,
      uuid: caseData.id
    }, rest, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    })));
  }, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
});