"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionHelpPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/advanced_detector_modal/function_help.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FunctionHelpPopover = exports.FunctionHelpPopover = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
  const onHelpClick = () => setIsHelpOpen(prevIsHelpOpen => !prevIsHelpOpen);
  const closeHelp = () => setIsHelpOpen(false);
  const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onHelpClick,
    iconType: "question",
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelpAriaLabel', {
      defaultMessage: 'Show help'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
  const columns = [{
    field: 'function',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.function', {
      defaultMessage: 'Function'
    }),
    width: '150px'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.description', {
      defaultMessage: 'Description'
    })
  }];
  const items = [{
    function: 'count, high_count, low_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.count', {
      defaultMessage: 'Detect anomalies when the number of events in a bucket is anomalous.'
    })
  }, {
    function: 'non_zero_count, high_non_zero_count, low_non_zero_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.nonZeroCount', {
      defaultMessage: 'Detect anomalies when the number of events in a bucket is anomalous, but ignore cases where the bucket count is zero.'
    })
  }, {
    function: 'distinct_count, high_distinct_count, low_distinct_count',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.distinctCount', {
      defaultMessage: 'Detect anomalies where the number of distinct values in one field is unusual.'
    })
  }, {
    function: 'lat_long',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.latLong', {
      defaultMessage: 'Detect anomalies in the geographic location of the input data.'
    })
  }, {
    function: 'info_content, high_info_content, low_info_content',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.infoContent', {
      defaultMessage: 'Detect anomalies in the amount of information that is contained in strings in a bucket.'
    })
  }, {
    function: 'min',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.min', {
      defaultMessage: 'Detect anomalies in the arithmetic minimum of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'max',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.max', {
      defaultMessage: 'Detect anomalies in the arithmetic maximum of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'median, high_median, low_median',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.median', {
      defaultMessage: 'Detect anomalies in the statistical median of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'mean, high_mean, low_mean',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.mean', {
      defaultMessage: 'Detect anomalies in the arithmetic mean of a value, which is calculated for each bucket.'
    })
  }, {
    function: 'metric',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.metric', {
      defaultMessage: 'Combine min, max, and mean functions. Use it as a shorthand for a combined analysis. This is the default function.'
    })
  }, {
    function: 'varp, high_varp, low_varp',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.varp', {
      defaultMessage: 'Detect anomalies in the variance of a value which is a measure of the variability and spread in the data.'
    })
  }, {
    function: 'rare',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.rare', {
      defaultMessage: 'Detect anomalies according to the number of distinct rare values.'
    })
  }, {
    function: 'freq_rare',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.freqRare', {
      defaultMessage: 'Detect anomalies according to the number of times (frequency) rare values occur.'
    })
  }, {
    function: 'sum, high_sum, low_sum',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.sum', {
      defaultMessage: 'Detect anomalies where the sum of a field in a bucket is anomalous.'
    })
  }, {
    function: 'non_null_sum, high_non_null_sum, low_non_null_sum',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.nonNullSum', {
      defaultMessage: 'These functions are useful if your data is sparse. Buckets without values are ignored and buckets with a zero value are analyzed.'
    })
  }, {
    function: 'time_of_day, time_of_week',
    description: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.functionHelp.time', {
      defaultMessage: 'Detect events that happen at unusual times, either of the day or of the week.'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "rightUp",
    button: helpButton,
    isOpen: isHelpOpen,
    display: "inlineBlock",
    panelPaddingSize: "none",
    closePopover: closeHelp,
    initialFocus: "#mlAdFunctionsHelpTableId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.functions.popoverTitle",
    defaultMessage: "Function reference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "eui-yScroll",
    css: {
      maxHeight: '40vh'
    },
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: "mlAdFunctionsHelpTableId",
    css: {
      width: 400
    },
    tableCaption: _i18n.i18n.translate('xpack.ml.anomalyDetection.functions.tableTitle', {
      defaultMessage: 'Description of functions'
    }),
    items: items,
    compressed: true,
    columns: columns,
    responsiveBreakpoint: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.functions.learnMoreText",
    defaultMessage: "Learn more about {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.ml.anomalyDetectionFunctions,
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.ml.anomalyDetection.functions.learnMoreLink', {
        defaultMessage: 'functions'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }))));
});