"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHART_TYPE = exports.AnomalyChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../contexts/kibana");
var _anomalies = require("../common/anomalies");
var _model_bounds = require("./model_bounds");
var _line = require("./line");
var _scatter = require("./scatter");
var _axes = require("../common/axes");
var _utils = require("../common/utils");
var _loading_wrapper = require("../loading_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/charts/anomaly_chart/anomaly_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CHART_TYPE = exports.CHART_TYPE = /*#__PURE__*/function (CHART_TYPE) {
  CHART_TYPE[CHART_TYPE["LINE"] = 0] = "LINE";
  CHART_TYPE[CHART_TYPE["SCATTER"] = 1] = "SCATTER";
  return CHART_TYPE;
}({});
const AnomalyChart = ({
  chartType,
  chartData = [],
  modelData,
  anomalyData,
  height,
  width,
  loading = false
}) => {
  const {
    services: {
      charts: {
        theme: {
          useChartsBaseTheme
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const baseTheme = useChartsBaseTheme();
  const data = chartType === CHART_TYPE.SCATTER ? flattenData(chartData) : chartData;
  const xDomain = (0, _utils.getXRange)(data);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width,
      height
    },
    "data-test-subj": `mlAnomalyChart ${CHART_TYPE[chartType]}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_loading_wrapper.LoadingWrapper, {
    height: height,
    hasData: data.length > 0,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    xDomain: xDomain,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_axes.Axes, {
    chartData: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_anomalies.Anomalies, {
    anomalyData: anomalyData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_model_bounds.ModelBounds, {
    modelData: modelData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), chartType === CHART_TYPE.LINE && /*#__PURE__*/_react.default.createElement(_line.Line, {
    chartData: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 45
    }
  }), chartType === CHART_TYPE.SCATTER && /*#__PURE__*/_react.default.createElement(_scatter.Scatter, {
    chartData: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 48
    }
  }))));
};
exports.AnomalyChart = AnomalyChart;
function flattenData(data) {
  const chartData = data.reduce((p, c) => {
    p.push(...c.values.map(v => ({
      time: c.time,
      value: v.value
    })));
    return p;
  }, []);
  return chartData;
}