"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopDatafeedsConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../contexts/kibana");
var _jobs_utils = require("../../../jobs_utils");
var _utils = require("../utils");
var _managed_jobs_warning_callout = require("./managed_jobs_warning_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/confirm_modals/stop_datafeeds_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StopDatafeedsConfirmModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const {
    services: {
      notifications: {
        toasts
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [hasManagedJob, setHasManaged] = (0, _react.useState)(true);
  const [jobsToStop, setJobsToStop] = (0, _react.useState)([]);
  const jobIds = (0, _react.useMemo)(() => jobsToStop.map(({
    id
  }) => id), [jobsToStop]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(jobs => {
    setJobsToStop(jobs);
    if (jobs.some(j => (0, _jobs_utils.isManagedJob)(j))) {
      setModalVisible(true);
      setHasManaged(true);
    }
  }, []);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    setHasManaged(false);
  }, []);
  if (modalVisible === false) {
    return null;
  }
  if (hasManagedJob) {
    const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.stopDatafeedsModal.stopDatafeedsTitle",
      defaultMessage: "Stop datafeed for {jobsCount, plural, one {{jobId}} other {# jobs}}?",
      values: {
        jobsCount: jobIds.length,
        jobId: jobIds[0]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "mlStopDatafeedsConfirmModal",
      onClose: closeModal,
      "aria-labelledby": modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: jobIds.length,
      action: _i18n.i18n.translate('xpack.ml.jobsList.stopDatafeedsModal.stopManagedDatafeedsDescription', {
        defaultMessage: 'stopping'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.stopDatafeedsConfirmModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        (0, _utils.stopDatafeeds)(toasts, mlApi, jobsToStop, refreshJobs);
        closeModal();
      },
      fill: true,
      color: "danger",
      "data-test-subj": "mlStopDatafeedsConfirmModalButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.stopDatafeedsConfirmModal.stopButtonLabel",
      defaultMessage: "Stop {jobsCount, plural, one {datafeed} other {datafeeds}}",
      values: {
        jobsCount: jobIds.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
exports.StopDatafeedsConfirmModal = StopDatafeedsConfirmModal;