"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cytoscape = Cytoscape;
exports.CytoscapeContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _cytoscape = _interopRequireDefault(require("cytoscape"));
var _cytoscapeDagre = _interopRequireDefault(require("cytoscape-dagre"));
var _cytoscape_options = require("./cytoscape_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/job_map/components/cytoscape.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore no declaration file
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
_cytoscape.default.use(_cytoscapeDagre.default);
const CytoscapeContext = exports.CytoscapeContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function useCytoscape(options) {
  const [cy, setCy] = (0, _react.useState)();
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!cy) {
      setCy((0, _cytoscape.default)({
        ...options,
        container: ref.current
      }));
    } else {
      // update styles for existing instance
      cy.style(options.style);
    }
  }, [options, cy]);

  // Destroy the cytoscape instance on unmount
  (0, _react.useEffect)(function destroyOnUnmount() {
    return () => {
      if (cy) {
        cy.destroy();
      }
    };
  }, [cy]);
  return [ref, cy];
}
function getLayoutOptions(width, height) {
  return {
    name: 'dagre',
    rankDir: 'LR',
    fit: true,
    padding: 20,
    spacingFactor: 0.95,
    boundingBox: {
      x1: 0,
      y1: 0,
      w: width,
      h: height
    }
  };
}
function Cytoscape({
  children,
  elements,
  height,
  itemsDeleted,
  resetCy,
  style,
  width
}) {
  const cytoscapeOptions = (0, _cytoscape_options.useCytoscapeOptions)();
  const cytoscapeOptionsWithElements = (0, _react.useMemo)(() => {
    return {
      ...cytoscapeOptions,
      elements
    };
  }, [cytoscapeOptions, elements]);
  const [ref, cy] = useCytoscape(cytoscapeOptionsWithElements);

  // Add the height to the div style. The height is a separate prop because it
  // is required and can trigger rendering when changed.
  const divStyle = (0, _react.useMemo)(() => {
    return {
      ...style,
      height,
      width
    };
  }, [style, height, width]);
  const dataHandler = (0, _react.useCallback)(event => {
    if (cy && height > 0) {
      // temporary workaround for single 'row' maps showing up outside of the graph bounds
      setTimeout(() => cy.layout(getLayoutOptions(width, height)).run(), 150);
    }
  }, [cy, height, width]);

  // Set up cytoscape event handlers
  (0, _react.useEffect)(() => {
    if (cy) {
      cy.on('data', dataHandler);
    }
    return () => {
      if (cy) {
        cy.removeListener('data', dataHandler);
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [cy, elements, height, width]);

  // Trigger a custom "data" event when data changes
  (0, _react.useEffect)(() => {
    if (cy) {
      if (itemsDeleted === false) {
        cy.add(elements);
      } else {
        cy.elements().remove();
        cy.add(elements);
      }
      cy.trigger('data');
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [cy, elements]);

  // Reset the graph to original zoom and pan
  (0, _react.useEffect)(() => {
    if (cy) {
      cy.reset();
      // Refitting because it's possible the the width/height have changed
      cy.fit();
    }
  }, [cy, resetCy, width, height]);
  return /*#__PURE__*/_react.default.createElement(CytoscapeContext.Provider, {
    value: cy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    css: (0, _react2.css)`
          ${divStyle}
        `,
    "data-test-subj": "mlPageDataFrameAnalyticsMapCytoscape",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, children));
}