"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditActionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlValidators = require("@kbn/ml-validators");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _analytics = require("../../../../common/analytics");
var _custom_urls = require("../../../../../components/custom_urls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_edit/edit_action_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let mmLValidator;
const EditActionFlyout = ({
  closeFlyout,
  item
}) => {
  const {
    id: jobId,
    config
  } = item;
  const {
    state
  } = item.stats;
  const initialAllowLazyStart = config.allow_lazy_start !== undefined ? String(config.allow_lazy_start) : '';
  const [allowLazyStart, setAllowLazyStart] = (0, _react.useState)(initialAllowLazyStart);
  const [description, setDescription] = (0, _react.useState)(config.description || '');
  const [modelMemoryLimit, setModelMemoryLimit] = (0, _react.useState)(config.model_memory_limit);
  const [mmlValidationError, setMmlValidationError] = (0, _react.useState)();
  const [maxNumThreads, setMaxNumThreads] = (0, _react.useState)(config.max_num_threads);
  const [activeTabId, setActiveTabId] = (0, _react.useState)('job-details');
  const [customUrls, setCustomUrls] = (0, _react.useState)([]);
  const [analyticsJob, setAnalyticsJob] = (0, _react.useState)();
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const {
    refresh
  } = (0, _analytics.useRefreshAnalyticsList)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = mlApi;
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();

  // Disable if mml is not valid
  const updateButtonDisabled = mmlValidationError !== undefined || maxNumThreads === 0;
  (0, _react.useEffect)(() => {
    if (mmLValidator === undefined) {
      mmLValidator = (0, _mlValidators.memoryInputValidator)();
    }
    // validate mml and create validation message
    if (modelMemoryLimit !== '') {
      const validationResult = mmLValidator(modelMemoryLimit);
      if (validationResult !== null && validationResult.invalidUnits) {
        setMmlValidationError(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.modelMemoryUnitsInvalidError', {
          defaultMessage: 'Model memory limit data unit unrecognized. It must be {str}',
          values: {
            str: validationResult.invalidUnits.allowedUnits
          }
        }));
      } else {
        setMmlValidationError(undefined);
      }
    } else {
      setMmlValidationError(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.modelMemoryEmptyError', {
        defaultMessage: 'Model memory limit must not be empty'
      }));
    }
  }, [modelMemoryLimit]);
  (0, _react.useEffect)(function fetchAnalyticsJob() {
    getDataFrameAnalytics(jobId).then(resp => {
      if (resp.data_frame_analytics.length) {
        var _job$_meta;
        const job = resp.data_frame_analytics[0];
        setAnalyticsJob(job);
        if ((_job$_meta = job._meta) !== null && _job$_meta !== void 0 && _job$_meta.custom_urls) {
          setCustomUrls(job._meta.custom_urls);
        }
      }
    });
  }, [jobId, getDataFrameAnalytics]);
  const updateDataFrameAnalytics = async updateConfig => {
    try {
      await mlApi.dataFrameAnalytics.updateDataFrameAnalytics(jobId, updateConfig);
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyoutSuccessMessage', {
        defaultMessage: 'Analytics job {jobId} has been updated.',
        values: {
          jobId
        }
      }));
      refresh();
      closeFlyout();
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error(e);
      toastNotificationService.displayErrorToast(e, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyoutErrorMessage', {
        defaultMessage: 'Could not save changes to analytics job {jobId}',
        values: {
          jobId
        }
      }));
    }
  };
  const onSubmit = async () => {
    if (activeTabId === 'job-details') {
      const updateConfig = Object.assign({
        allow_lazy_start: allowLazyStart,
        description
      }, modelMemoryLimit && {
        model_memory_limit: modelMemoryLimit
      }, maxNumThreads && {
        max_num_threads: maxNumThreads
      });
      await updateDataFrameAnalytics(updateConfig);
    } else if (activeTabId === 'custom-urls') {
      var _analyticsJob$_meta;
      const meta = (_analyticsJob$_meta = analyticsJob === null || analyticsJob === void 0 ? void 0 : analyticsJob._meta) !== null && _analyticsJob$_meta !== void 0 ? _analyticsJob$_meta : {};
      delete meta.custom_urls;
      // Only update custom urls and leave anything else in _meta untouched
      const updateConfig = {
        _meta: {
          ...meta,
          custom_urls: customUrls
        }
      };
      await updateDataFrameAnalytics(updateConfig);
    }
  };
  const jobDetailsContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.allowLazyStartLabel', {
      defaultMessage: 'Allow lazy start'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.allowLazyStartAriaLabel', {
      defaultMessage: 'Update allow lazy start.'
    }),
    "data-test-subj": "mlAnalyticsEditFlyoutAllowLazyStartInput",
    options: [{
      value: 'true',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.allowLazyStartTrueValue', {
        defaultMessage: 'True'
      })
    }, {
      value: 'false',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.allowLazyStartFalseValue', {
        defaultMessage: 'False'
      })
    }],
    value: allowLazyStart,
    onChange: e => setAllowLazyStart(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.descriptionLabel', {
      defaultMessage: 'Description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "mlAnalyticsEditFlyoutDescriptionInput",
    value: description,
    onChange: e => setDescription(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.descriptionAriaLabel', {
      defaultMessage: 'Update the job description.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: state !== _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STOPPED && _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.modelMemoryHelpText', {
      defaultMessage: 'Model memory limit cannot be edited until the job has stopped.'
    }),
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.modelMemoryLimitLabel', {
      defaultMessage: 'Model memory limit'
    }),
    isInvalid: mmlValidationError !== undefined,
    error: mmlValidationError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "mlAnalyticsEditFlyoutmodelMemoryLimitInput",
    isInvalid: mmlValidationError !== undefined,
    readOnly: state !== _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STOPPED,
    value: modelMemoryLimit,
    onChange: e => setModelMemoryLimit(e.target.value),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.modelMemoryLimitAriaLabel', {
      defaultMessage: 'Update the model memory limit.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: state !== _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STOPPED && _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.maxNumThreadsHelpText', {
      defaultMessage: 'Maximum number of threads cannot be edited until the job has stopped.'
    }),
    label: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.maxNumThreadsLabel', {
      defaultMessage: 'Maximum number of threads'
    }),
    isInvalid: maxNumThreads === 0,
    error: maxNumThreads === 0 && _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.maxNumThreadsError', {
      defaultMessage: 'The minimum value is 1.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: maxNumThreads === 0,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyout.maxNumThreadsAriaLabel', {
      defaultMessage: 'Update the maximum number of threads to be used by the analysis.'
    }),
    "data-test-subj": "mlAnalyticsEditFlyoutMaxNumThreadsLimitInput",
    onChange: e => setMaxNumThreads(e.target.value === '' ? undefined : +e.target.value),
    step: 1,
    min: 1,
    readOnly: state !== _mlDataFrameAnalyticsUtils.DATA_FRAME_TASK_STATE.STOPPED,
    value: maxNumThreads,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }))));
  const tabs = [{
    id: 'job-details',
    'data-test-subj': 'mlEditAnalyticsJobFlyout-jobDetails',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editJobFlyout.jobDetailsTitle', {
      defaultMessage: 'Job details'
    }),
    content: jobDetailsContent
  }, {
    id: 'custom-urls',
    'data-test-subj': 'mlEditAnalyticsJobFlyout-customUrls',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editJobFlyout.customUrlsTitle', {
      defaultMessage: 'Custom URLs'
    }),
    content: /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrlsWrapper, {
      job: analyticsJob,
      jobCustomUrls: customUrls,
      setCustomUrls: setCustomUrls,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 9
      }
    })
  }];
  const isValidJobCustomUrls = (0, _react.useMemo)(() => (0, _custom_urls.isValidCustomUrls)(customUrls), [customUrls]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    hideCloseButton: true,
    "aria-labelledby": "analyticsEditFlyoutTitle",
    "data-test-subj": "mlAnalyticsEditFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "analyticsEditFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyoutTitle', {
    defaultMessage: 'Edit {jobId}',
    values: {
      jobId
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    onTabClick: ({
      id
    }) => {
      setActiveTabId(id);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "mlAnalyticsEditFlyoutCancelButton",
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyoutCancelButtonText', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlAnalyticsEditFlyoutUpdateButton",
    onClick: onSubmit,
    fill: true,
    isDisabled: updateButtonDisabled || isValidJobCustomUrls === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.editFlyoutUpdateButtonText', {
    defaultMessage: 'Update'
  }))))));
};
exports.EditActionFlyout = EditActionFlyout;