"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluateStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _analytics = require("../../../../common/analytics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/regression_exploration/evaluate_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const statDescriptions = {
  [_analytics.REGRESSION_STATS.MSE]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.meanSquaredErrorText', {
    defaultMessage: 'Mean squared error'
  }),
  [_analytics.REGRESSION_STATS.MSLE]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.msleText', {
    defaultMessage: 'Mean squared logarithmic error'
  }),
  [_analytics.REGRESSION_STATS.R_SQUARED]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.rSquaredText', {
    defaultMessage: 'R squared'
  }),
  [_analytics.REGRESSION_STATS.HUBER]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.regressionExploration.huberText",
    defaultMessage: "{wikiLink}",
    values: {
      wikiLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://en.wikipedia.org/wiki/Huber_loss#Pseudo-Huber_loss_function",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.huberLinkText', {
        defaultMessage: 'Pseudo Huber loss function'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  })
};
const tooltipContent = {
  [_analytics.REGRESSION_STATS.MSE]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.meanSquaredErrorTooltipContent', {
    defaultMessage: 'Measures how well the regression analysis model is performing. Mean squared sum of the difference between true and predicted values.'
  }),
  [_analytics.REGRESSION_STATS.MSLE]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.msleTooltipContent', {
    defaultMessage: 'Average squared difference between the logarithm of the predicted values and the logarithm of the actual (ground truth) value.'
  }),
  [_analytics.REGRESSION_STATS.R_SQUARED]: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.rSquaredTooltipContent', {
    defaultMessage: 'Represents the goodness of fit. Measures how well the observed outcomes are replicated by the model.'
  })
};
const EvaluateStat = ({
  isLoading,
  statType,
  title,
  dataTestSubj
}) => {
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": dataTestSubj,
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    reverse: true,
    isLoading: isLoading,
    title: title,
    description: statDescriptions[statType],
    titleSize: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingBottom: `${size.xxs}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, statType !== _analytics.REGRESSION_STATS.HUBER && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltipContent[statType],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 49
    }
  })));
};
exports.EvaluateStat = EvaluateStat;