"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../ml_inference/constants");
var _get_steps = require("../ml_inference/get_steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/shared/add_inference_pipeline_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddInferencePipelineFooter = ({
  isDetailsStepValid,
  isConfigureProcessorStepValid,
  creatingPipeline,
  pipelineCreated,
  onClose,
  onCreate,
  step,
  setStep,
  hasProcessorStep
}) => {
  const {
    nextStep,
    previousStep,
    isContinueButtonEnabled
  } = (0, _react.useMemo)(() => (0, _get_steps.getSteps)(step, isDetailsStepValid, isConfigureProcessorStepValid, hasProcessorStep), [isDetailsStepValid, isConfigureProcessorStepValid, step, hasProcessorStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "mlTrainedModelsInferencePipelineCloseButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, pipelineCreated ? _constants.CLOSE_BUTTON_LABEL : _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, previousStep !== undefined && pipelineCreated === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    iconType: "arrowLeft",
    onClick: () => setStep(previousStep),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, _constants.BACK_BUTTON_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, nextStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineContinueButton",
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => setStep(nextStep),
    disabled: !isContinueButtonEnabled,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, _constants.CONTINUE_BUTTON_LABEL) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineCreateButton",
    color: "success",
    disabled: !isContinueButtonEnabled || creatingPipeline || pipelineCreated,
    fill: true,
    onClick: onCreate,
    isLoading: creatingPipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.addInferencePipelineModal.footer.create', {
    defaultMessage: 'Create pipeline'
  }))));
};
exports.AddInferencePipelineFooter = AddInferencePipelineFooter;