"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDimensions = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlComposer = require("@kbn/esql-composer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDimensions = async ({
  esClient,
  dimensions,
  indices,
  from,
  to,
  logger
}) => {
  if (!dimensions || dimensions.length === 0) {
    return [];
  }
  const source = (0, _esqlComposer.from)(indices);
  const query = source.pipe((0, _esqlComposer.evaluate)('??dim = ??dim::string', {
    dim: dimensions[0]
  }), (0, _esqlComposer.where)('??dim IS NOT NULL', {
    dim: dimensions[0]
  }), (0, _esqlComposer.stats)('BY ??dim', {
    dim: dimensions[0]
  }), (0, _esqlComposer.sort)('??dim', {
    dim: dimensions[0]
  }), (0, _esqlComposer.limit)(20)).toString();
  try {
    const response = await esClient.esql('get_dimensions', {
      query,
      filter: {
        bool: {
          filter: [...(0, _esQuery.dateRangeQuery)(from, to)]
        }
      }
    }, {
      transform: 'plain'
    });
    return response.hits.map(hit => ({
      value: String(hit[dimensions[0]]),
      field: dimensions[0]
    }));
  } catch (error) {
    logger.error('Error fetching dimension values:', error);
    return [];
  }
};
exports.getDimensions = getDimensions;