"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupMapEmbeddable = setupMapEmbeddable;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function setupMapEmbeddable(embeddableSetup) {
  embeddableSetup.registerReactEmbeddableFactory(_constants.MAP_SAVED_OBJECT_TYPE, async () => {
    const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
    const [, {
      mapEmbeddableFactory
    }] = await Promise.all([startServicesPromise, Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_module')))]);
    return mapEmbeddableFactory;
  });
  embeddableSetup.registerAddFromLibraryType({
    onAdd: async (container, savedObject) => {
      container.addNewPanel({
        panelType: _constants.MAP_SAVED_OBJECT_TYPE,
        serializedState: {
          rawState: {
            savedObjectId: savedObject.id
          },
          references: []
        }
      }, true);
    },
    savedObjectType: _constants.MAP_SAVED_OBJECT_TYPE,
    savedObjectName: _i18n.i18n.translate('xpack.maps.mapSavedObjectLabel', {
      defaultMessage: 'Map'
    }),
    getIconForSavedObject: () => _constants.APP_ICON
  });
  embeddableSetup.registerLegacyURLTransform(_constants.MAP_SAVED_OBJECT_TYPE, async () => {
    const {
      getTransformOut
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_module')));
    return getTransformOut(embeddableSetup.transformEnhancementsOut);
  });
}