"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawFilterControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
var _kibana_services = require("../../../../kibana_services");
var _draw_control = require("../draw_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/draw_control/draw_filter_control/draw_filter_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DrawFilterControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_onDraw", async e => {
      if (!e.features.length || !this.props.drawState || !this.props.geoFieldNames.length) {
        return;
      }
      let filter;
      if (this.props.drawState.drawShape === _constants.DRAW_SHAPE.DISTANCE) {
        const circle = e.features[0];
        const distanceKm = _lodash.default.round(circle.properties.radiusKm, circle.properties.radiusKm > 10 ? 0 : 2);
        // Only include as much precision as needed for distance
        let precision = 2;
        if (distanceKm <= 1) {
          precision = 5;
        } else if (distanceKm <= 10) {
          precision = 4;
        } else if (distanceKm <= 100) {
          precision = 3;
        }
        filter = (0, _elasticsearch_util.createDistanceFilterWithMeta)({
          alias: this.props.drawState.filterLabel ? this.props.drawState.filterLabel : '',
          distanceKm,
          geoFieldNames: this.props.geoFieldNames,
          point: [_lodash.default.round(circle.properties.center[0], precision), _lodash.default.round(circle.properties.center[1], precision)]
        });
      } else {
        const geometry = e.features[0].geometry;
        // MapboxDraw returns coordinates with 12 decimals. Round to a more reasonable number
        (0, _elasticsearch_util.roundCoordinates)(geometry.coordinates);
        filter = (0, _elasticsearch_util.buildGeoShapeFilter)({
          geometry: this.props.drawState.drawShape === _constants.DRAW_SHAPE.BOUNDS ? (0, _elasticsearch_util.getBoundingBoxGeometry)(geometry) : geometry,
          geoFieldNames: this.props.geoFieldNames,
          geometryLabel: this.props.drawState.geometryLabel ? this.props.drawState.geometryLabel : '',
          relation: this.props.drawState.relation ? this.props.drawState.relation : 'intersects'
        });
      }
      try {
        await this.props.addFilters([filter], this.props.drawState.actionId);
      } catch (error) {
        (0, _kibana_services.getToasts)().addWarning(_i18n.i18n.translate('xpack.maps.drawFilterControl.unableToCreatFilter', {
          defaultMessage: `Unable to create filter, error: ''{errorMsg}''.`,
          values: {
            errorMsg: error.message
          }
        }));
      } finally {
        this.props.disableDrawState();
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_draw_control.DrawControl, {
      drawShape: this.props.filterModeActive && this.props.drawState ? this.props.drawState.drawShape : undefined,
      onDraw: this._onDraw,
      mbMap: this.props.mbMap,
      enable: this.props.filterModeActive,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    });
  }
}
exports.DrawFilterControl = DrawFilterControl;