"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SizeRangeSelector = SizeRangeSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _vector_style_defaults = require("../../vector_style_defaults");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/size/size_range_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SizeRangeSelector({
  minSize,
  maxSize,
  onChange,
  ...rest
}) {
  const onSizeChange = ([min, max]) => {
    onChange({
      minSize: Math.max(_vector_style_defaults.MIN_SIZE, parseInt(min, 10)),
      maxSize: Math.min(_vector_style_defaults.MAX_SIZE, parseInt(max, 10))
    });
  };
  return /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, (0, _extends2.default)({
    min: _vector_style_defaults.MIN_SIZE,
    max: _vector_style_defaults.MAX_SIZE,
    step: 1,
    value: [minSize, maxSize],
    showInput: "inputWithPopover",
    showRange: true,
    onChange: onSizeChange,
    allowEmptyRange: false,
    append: _i18n.i18n.translate('xpack.maps.vector.dualSize.unitLabel', {
      defaultMessage: 'px',
      description: 'Shorthand for pixel'
    })
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }));
}