"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _color_gradient = require("./color_gradient");
var _ranged_style_legend_row = require("../../../components/ranged_style_legend_row");
var _heatmap_constants = require("../heatmap_constants");
var _mask_legend = require("../../../vector/components/legend/mask_legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/heatmap/components/legend/heatmap_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class HeatmapLegend extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: ''
    });
  }
  componentDidUpdate() {
    this._loadLabel();
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadLabel();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadLabel() {
    const label = await this.props.field.getLabel();
    if (this._isMounted && this.state.label !== label) {
      this.setState({
        label
      });
    }
  }
  render() {
    const metricLegend = /*#__PURE__*/_react.default.createElement(_ranged_style_legend_row.RangedStyleLegendRow, {
      header: /*#__PURE__*/_react.default.createElement(_color_gradient.ColorGradient, {
        colorPaletteId: this.props.colorRampName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 17
        }
      }),
      minLabel: _i18n.i18n.translate('xpack.maps.heatmapLegend.coldLabel', {
        defaultMessage: 'cold'
      }),
      maxLabel: _i18n.i18n.translate('xpack.maps.heatmapLegend.hotLabel', {
        defaultMessage: 'hot'
      }),
      propertyLabel: _heatmap_constants.HEATMAP_COLOR_RAMP_LABEL,
      fieldLabel: this.state.label,
      invert: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    });
    let maskLegend;
    if ('getMask' in this.props.field) {
      const mask = this.props.field.getMask();
      if (mask) {
        maskLegend = /*#__PURE__*/_react.default.createElement(_mask_legend.MaskLegend, {
          esAggField: this.props.field,
          operator: mask.operator,
          value: mask.value,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 11
          }
        });
      }
    }
    return maskLegend ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, maskLegend, metricLegend) : metricLegend;
  }
}
exports.HeatmapLegend = HeatmapLegend;