"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAP_SAVED_OBJECT_REF_NAME = void 0;
exports.getTransformIn = getTransformIn;
var _constants = require("../../constants");
var _transform_map_attributes_in = require("../../content_management/transform_map_attributes_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAP_SAVED_OBJECT_REF_NAME = exports.MAP_SAVED_OBJECT_REF_NAME = 'savedObjectRef';
function getTransformIn(transformEnhancementsIn) {
  function transformIn(state) {
    const {
      enhancementsState,
      enhancementsReferences
    } = state.enhancements ? transformEnhancementsIn(state.enhancements) : {
      enhancementsState: undefined,
      enhancementsReferences: []
    };

    // by ref
    if (state.savedObjectId) {
      const {
        savedObjectId,
        ...rest
      } = state;
      return {
        state: {
          ...rest,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {})
        },
        references: [{
          name: MAP_SAVED_OBJECT_REF_NAME,
          type: _constants.MAP_SAVED_OBJECT_TYPE,
          id: savedObjectId
        }, ...enhancementsReferences]
      };
    }

    // by value
    if (state.attributes) {
      const {
        attributes,
        references
      } = (0, _transform_map_attributes_in.transformMapAttributesIn)(state.attributes);
      return {
        state: {
          ...state,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {}),
          attributes
        },
        references: [...references, ...enhancementsReferences]
      };
    }
    return {
      state: {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {})
      },
      references: enhancementsReferences
    };
  }
  return transformIn;
}